// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The data stored in JSON format. </summary>
    public partial class JsonFormat : DatasetStorageFormat
    {
        /// <summary> Initializes a new instance of <see cref="JsonFormat"/>. </summary>
        public JsonFormat()
        {
            Type = "JsonFormat";
        }

        /// <summary> Initializes a new instance of <see cref="JsonFormat"/>. </summary>
        /// <param name="type"> Type of dataset storage format. </param>
        /// <param name="serializer"> Serializer. Type: string (or Expression with resultType string). </param>
        /// <param name="deserializer"> Deserializer. Type: string (or Expression with resultType string). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="filePattern"> File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive. </param>
        /// <param name="nestingSeparator"> The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string). </param>
        /// <param name="encodingName"> The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string). </param>
        /// <param name="jsonNodeReference"> The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string). </param>
        /// <param name="jsonPathDefinition"> The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object). </param>
        internal JsonFormat(string type, object serializer, object deserializer, IDictionary<string, object> additionalProperties, object filePattern, object nestingSeparator, object encodingName, object jsonNodeReference, object jsonPathDefinition) : base(type, serializer, deserializer, additionalProperties)
        {
            FilePattern = filePattern;
            NestingSeparator = nestingSeparator;
            EncodingName = encodingName;
            JsonNodeReference = jsonNodeReference;
            JsonPathDefinition = jsonPathDefinition;
            Type = type ?? "JsonFormat";
        }

        /// <summary> File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'. It is case-sensitive. </summary>
        public object FilePattern { get; set; }
        /// <summary> The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType string). </summary>
        public object NestingSeparator { get; set; }
        /// <summary> The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark (BOM) denotes another Unicode encoding. The full list of supported values can be found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078. Type: string (or Expression with resultType string). </summary>
        public object EncodingName { get; set; }
        /// <summary> The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType string). </summary>
        public object JsonNodeReference { get; set; }
        /// <summary> The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields under root object, start with "$"; for fields inside the array chosen by jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}. Type: object (or Expression with resultType object). </summary>
        public object JsonPathDefinition { get; set; }
    }
}
