// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> VNet properties for managed integration runtime. </summary>
    public partial class IntegrationRuntimeVNetProperties
    {
        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeVNetProperties"/>. </summary>
        public IntegrationRuntimeVNetProperties()
        {
            PublicIPs = new ChangeTrackingList<string>();
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeVNetProperties"/>. </summary>
        /// <param name="vNetId"> The ID of the VNet that this integration runtime will join. </param>
        /// <param name="subnet"> The name of the subnet this integration runtime will join. </param>
        /// <param name="publicIPs"> Resource IDs of the public IP addresses that this integration runtime will use. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal IntegrationRuntimeVNetProperties(string vNetId, string subnet, IList<string> publicIPs, IDictionary<string, object> additionalProperties)
        {
            VNetId = vNetId;
            Subnet = subnet;
            PublicIPs = publicIPs;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The ID of the VNet that this integration runtime will join. </summary>
        public string VNetId { get; set; }
        /// <summary> The name of the subnet this integration runtime will join. </summary>
        public string Subnet { get; set; }
        /// <summary> Resource IDs of the public IP addresses that this integration runtime will use. </summary>
        public IList<string> PublicIPs { get; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
