// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> SSIS properties for managed integration runtime. </summary>
    public partial class IntegrationRuntimeSsisProperties
    {
        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeSsisProperties"/>. </summary>
        public IntegrationRuntimeSsisProperties()
        {
            ExpressCustomSetupProperties = new ChangeTrackingList<CustomSetupBase>();
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeSsisProperties"/>. </summary>
        /// <param name="catalogInfo"> Catalog information for managed dedicated integration runtime. </param>
        /// <param name="licenseType"> License type for bringing your own license scenario. </param>
        /// <param name="customSetupScriptProperties"> Custom setup script properties for a managed dedicated integration runtime. </param>
        /// <param name="dataProxyProperties"> Data proxy properties for a managed dedicated integration runtime. </param>
        /// <param name="edition"> The edition for the SSIS Integration Runtime. </param>
        /// <param name="expressCustomSetupProperties"> Custom setup without script properties for a SSIS integration runtime. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal IntegrationRuntimeSsisProperties(IntegrationRuntimeSsisCatalogInfo catalogInfo, IntegrationRuntimeLicenseType? licenseType, IntegrationRuntimeCustomSetupScriptProperties customSetupScriptProperties, IntegrationRuntimeDataProxyProperties dataProxyProperties, IntegrationRuntimeEdition? edition, IList<CustomSetupBase> expressCustomSetupProperties, IDictionary<string, object> additionalProperties)
        {
            CatalogInfo = catalogInfo;
            LicenseType = licenseType;
            CustomSetupScriptProperties = customSetupScriptProperties;
            DataProxyProperties = dataProxyProperties;
            Edition = edition;
            ExpressCustomSetupProperties = expressCustomSetupProperties;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Catalog information for managed dedicated integration runtime. </summary>
        public IntegrationRuntimeSsisCatalogInfo CatalogInfo { get; set; }
        /// <summary> License type for bringing your own license scenario. </summary>
        public IntegrationRuntimeLicenseType? LicenseType { get; set; }
        /// <summary> Custom setup script properties for a managed dedicated integration runtime. </summary>
        public IntegrationRuntimeCustomSetupScriptProperties CustomSetupScriptProperties { get; set; }
        /// <summary> Data proxy properties for a managed dedicated integration runtime. </summary>
        public IntegrationRuntimeDataProxyProperties DataProxyProperties { get; set; }
        /// <summary> The edition for the SSIS Integration Runtime. </summary>
        public IntegrationRuntimeEdition? Edition { get; set; }
        /// <summary> Custom setup without script properties for a SSIS integration runtime. </summary>
        public IList<CustomSetupBase> ExpressCustomSetupProperties { get; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
