// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Catalog information for managed dedicated integration runtime. </summary>
    public partial class IntegrationRuntimeSsisCatalogInfo
    {
        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeSsisCatalogInfo"/>. </summary>
        public IntegrationRuntimeSsisCatalogInfo()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeSsisCatalogInfo"/>. </summary>
        /// <param name="catalogServerEndpoint"> The catalog database server URL. </param>
        /// <param name="catalogAdminUserName"> The administrator user name of catalog database. </param>
        /// <param name="catalogAdminPassword"> The password of the administrator user account of the catalog database. </param>
        /// <param name="catalogPricingTier"> The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal IntegrationRuntimeSsisCatalogInfo(string catalogServerEndpoint, string catalogAdminUserName, SecureString catalogAdminPassword, IntegrationRuntimeSsisCatalogPricingTier? catalogPricingTier, IDictionary<string, object> additionalProperties)
        {
            CatalogServerEndpoint = catalogServerEndpoint;
            CatalogAdminUserName = catalogAdminUserName;
            CatalogAdminPassword = catalogAdminPassword;
            CatalogPricingTier = catalogPricingTier;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The catalog database server URL. </summary>
        public string CatalogServerEndpoint { get; set; }
        /// <summary> The administrator user name of catalog database. </summary>
        public string CatalogAdminUserName { get; set; }
        /// <summary> The password of the administrator user account of the catalog database. </summary>
        public SecureString CatalogAdminPassword { get; set; }
        /// <summary> The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/. </summary>
        public IntegrationRuntimeSsisCatalogPricingTier? CatalogPricingTier { get; set; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
