// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(IntegrationRuntimeSsisCatalogInfoConverter))]
    public partial class IntegrationRuntimeSsisCatalogInfo : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(CatalogServerEndpoint))
            {
                writer.WritePropertyName("catalogServerEndpoint"u8);
                writer.WriteStringValue(CatalogServerEndpoint);
            }
            if (Optional.IsDefined(CatalogAdminUserName))
            {
                writer.WritePropertyName("catalogAdminUserName"u8);
                writer.WriteStringValue(CatalogAdminUserName);
            }
            if (Optional.IsDefined(CatalogAdminPassword))
            {
                writer.WritePropertyName("catalogAdminPassword"u8);
                writer.WriteObjectValue(CatalogAdminPassword);
            }
            if (Optional.IsDefined(CatalogPricingTier))
            {
                writer.WritePropertyName("catalogPricingTier"u8);
                writer.WriteStringValue(CatalogPricingTier.Value.ToString());
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static IntegrationRuntimeSsisCatalogInfo DeserializeIntegrationRuntimeSsisCatalogInfo(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string catalogServerEndpoint = default;
            string catalogAdminUserName = default;
            SecureString catalogAdminPassword = default;
            IntegrationRuntimeSsisCatalogPricingTier? catalogPricingTier = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("catalogServerEndpoint"u8))
                {
                    catalogServerEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("catalogAdminUserName"u8))
                {
                    catalogAdminUserName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("catalogAdminPassword"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    catalogAdminPassword = SecureString.DeserializeSecureString(property.Value);
                    continue;
                }
                if (property.NameEquals("catalogPricingTier"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    catalogPricingTier = new IntegrationRuntimeSsisCatalogPricingTier(property.Value.GetString());
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new IntegrationRuntimeSsisCatalogInfo(catalogServerEndpoint, catalogAdminUserName, catalogAdminPassword, catalogPricingTier, additionalProperties);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IntegrationRuntimeSsisCatalogInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIntegrationRuntimeSsisCatalogInfo(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class IntegrationRuntimeSsisCatalogInfoConverter : JsonConverter<IntegrationRuntimeSsisCatalogInfo>
        {
            public override void Write(Utf8JsonWriter writer, IntegrationRuntimeSsisCatalogInfo model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override IntegrationRuntimeSsisCatalogInfo Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeIntegrationRuntimeSsisCatalogInfo(document.RootElement);
            }
        }
    }
}
