// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A list of integration runtime resources. </summary>
    public partial class IntegrationRuntimeListResponse
    {
        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeListResponse"/>. </summary>
        /// <param name="value"> List of integration runtimes. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal IntegrationRuntimeListResponse(IEnumerable<IntegrationRuntimeResource> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeListResponse"/>. </summary>
        /// <param name="value"> List of integration runtimes. </param>
        /// <param name="nextLink"> The link to the next page of results, if any remaining results exist. </param>
        internal IntegrationRuntimeListResponse(IReadOnlyList<IntegrationRuntimeResource> value, string nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> List of integration runtimes. </summary>
        public IReadOnlyList<IntegrationRuntimeResource> Value { get; }
        /// <summary> The link to the next page of results, if any remaining results exist. </summary>
        public string NextLink { get; }
    }
}
