// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Data proxy properties for a managed dedicated integration runtime. </summary>
    public partial class IntegrationRuntimeDataProxyProperties
    {
        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeDataProxyProperties"/>. </summary>
        public IntegrationRuntimeDataProxyProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntimeDataProxyProperties"/>. </summary>
        /// <param name="connectVia"> The self-hosted integration runtime reference. </param>
        /// <param name="stagingLinkedService"> The staging linked service reference. </param>
        /// <param name="path"> The path to contain the staged data in the Blob storage. </param>
        internal IntegrationRuntimeDataProxyProperties(EntityReference connectVia, EntityReference stagingLinkedService, string path)
        {
            ConnectVia = connectVia;
            StagingLinkedService = stagingLinkedService;
            Path = path;
        }

        /// <summary> The self-hosted integration runtime reference. </summary>
        public EntityReference ConnectVia { get; set; }
        /// <summary> The staging linked service reference. </summary>
        public EntityReference StagingLinkedService { get; set; }
        /// <summary> The path to contain the staged data in the Blob storage. </summary>
        public string Path { get; set; }
    }
}
