// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary>
    /// Azure Synapse nested object which serves as a compute resource for activities.
    /// Please note <see cref="IntegrationRuntime"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="ManagedIntegrationRuntime"/> and <see cref="SelfHostedIntegrationRuntime"/>.
    /// </summary>
    public abstract partial class IntegrationRuntime
    {
        /// <summary> Initializes a new instance of <see cref="IntegrationRuntime"/>. </summary>
        protected IntegrationRuntime()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationRuntime"/>. </summary>
        /// <param name="type"> Type of integration runtime. </param>
        /// <param name="description"> Integration runtime description. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal IntegrationRuntime(IntegrationRuntimeType type, string description, IDictionary<string, object> additionalProperties)
        {
            Type = type;
            Description = description;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Type of integration runtime. </summary>
        internal IntegrationRuntimeType Type { get; set; }
        /// <summary> Integration runtime description. </summary>
        public string Description { get; set; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
