// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The location of http server. </summary>
    public partial class HttpServerLocation : DatasetLocation
    {
        /// <summary> Initializes a new instance of <see cref="HttpServerLocation"/>. </summary>
        public HttpServerLocation()
        {
            Type = "HttpServerLocation";
        }

        /// <summary> Initializes a new instance of <see cref="HttpServerLocation"/>. </summary>
        /// <param name="type"> Type of dataset storage location. </param>
        /// <param name="folderPath"> Specify the folder path of dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="fileName"> Specify the file name of dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="relativeUrl"> Specify the relativeUrl of http server. Type: string (or Expression with resultType string). </param>
        internal HttpServerLocation(string type, object folderPath, object fileName, IDictionary<string, object> additionalProperties, object relativeUrl) : base(type, folderPath, fileName, additionalProperties)
        {
            RelativeUrl = relativeUrl;
            Type = type ?? "HttpServerLocation";
        }

        /// <summary> Specify the relativeUrl of http server. Type: string (or Expression with resultType string). </summary>
        public object RelativeUrl { get; set; }
    }
}
