// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(HDInsightOnDemandLinkedServiceConverter))]
    public partial class HDInsightOnDemandLinkedService : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("type"u8);
            writer.WriteStringValue(Type);
            if (Optional.IsDefined(ConnectVia))
            {
                writer.WritePropertyName("connectVia"u8);
                writer.WriteObjectValue(ConnectVia);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsCollectionDefined(Parameters))
            {
                writer.WritePropertyName("parameters"u8);
                writer.WriteStartObject();
                foreach (var item in Parameters)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteObjectValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Annotations))
            {
                writer.WritePropertyName("annotations"u8);
                writer.WriteStartArray();
                foreach (var item in Annotations)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteObjectValue<object>(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("typeProperties"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("clusterSize"u8);
            writer.WriteObjectValue<object>(ClusterSize);
            writer.WritePropertyName("timeToLive"u8);
            writer.WriteObjectValue<object>(TimeToLive);
            writer.WritePropertyName("version"u8);
            writer.WriteObjectValue<object>(Version);
            writer.WritePropertyName("linkedServiceName"u8);
            writer.WriteObjectValue(LinkedServiceName);
            writer.WritePropertyName("hostSubscriptionId"u8);
            writer.WriteObjectValue<object>(HostSubscriptionId);
            if (Optional.IsDefined(ServicePrincipalId))
            {
                writer.WritePropertyName("servicePrincipalId"u8);
                writer.WriteObjectValue<object>(ServicePrincipalId);
            }
            if (Optional.IsDefined(ServicePrincipalKey))
            {
                writer.WritePropertyName("servicePrincipalKey"u8);
                writer.WriteObjectValue(ServicePrincipalKey);
            }
            writer.WritePropertyName("tenant"u8);
            writer.WriteObjectValue<object>(Tenant);
            writer.WritePropertyName("clusterResourceGroup"u8);
            writer.WriteObjectValue<object>(ClusterResourceGroup);
            if (Optional.IsDefined(ClusterNamePrefix))
            {
                writer.WritePropertyName("clusterNamePrefix"u8);
                writer.WriteObjectValue<object>(ClusterNamePrefix);
            }
            if (Optional.IsDefined(ClusterUserName))
            {
                writer.WritePropertyName("clusterUserName"u8);
                writer.WriteObjectValue<object>(ClusterUserName);
            }
            if (Optional.IsDefined(ClusterPassword))
            {
                writer.WritePropertyName("clusterPassword"u8);
                writer.WriteObjectValue(ClusterPassword);
            }
            if (Optional.IsDefined(ClusterSshUserName))
            {
                writer.WritePropertyName("clusterSshUserName"u8);
                writer.WriteObjectValue<object>(ClusterSshUserName);
            }
            if (Optional.IsDefined(ClusterSshPassword))
            {
                writer.WritePropertyName("clusterSshPassword"u8);
                writer.WriteObjectValue(ClusterSshPassword);
            }
            if (Optional.IsCollectionDefined(AdditionalLinkedServiceNames))
            {
                writer.WritePropertyName("additionalLinkedServiceNames"u8);
                writer.WriteStartArray();
                foreach (var item in AdditionalLinkedServiceNames)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(HcatalogLinkedServiceName))
            {
                writer.WritePropertyName("hcatalogLinkedServiceName"u8);
                writer.WriteObjectValue(HcatalogLinkedServiceName);
            }
            if (Optional.IsDefined(ClusterType))
            {
                writer.WritePropertyName("clusterType"u8);
                writer.WriteObjectValue<object>(ClusterType);
            }
            if (Optional.IsDefined(SparkVersion))
            {
                writer.WritePropertyName("sparkVersion"u8);
                writer.WriteObjectValue<object>(SparkVersion);
            }
            if (Optional.IsDefined(CoreConfiguration))
            {
                writer.WritePropertyName("coreConfiguration"u8);
                writer.WriteObjectValue<object>(CoreConfiguration);
            }
            if (Optional.IsDefined(HBaseConfiguration))
            {
                writer.WritePropertyName("hBaseConfiguration"u8);
                writer.WriteObjectValue<object>(HBaseConfiguration);
            }
            if (Optional.IsDefined(HdfsConfiguration))
            {
                writer.WritePropertyName("hdfsConfiguration"u8);
                writer.WriteObjectValue<object>(HdfsConfiguration);
            }
            if (Optional.IsDefined(HiveConfiguration))
            {
                writer.WritePropertyName("hiveConfiguration"u8);
                writer.WriteObjectValue<object>(HiveConfiguration);
            }
            if (Optional.IsDefined(MapReduceConfiguration))
            {
                writer.WritePropertyName("mapReduceConfiguration"u8);
                writer.WriteObjectValue<object>(MapReduceConfiguration);
            }
            if (Optional.IsDefined(OozieConfiguration))
            {
                writer.WritePropertyName("oozieConfiguration"u8);
                writer.WriteObjectValue<object>(OozieConfiguration);
            }
            if (Optional.IsDefined(StormConfiguration))
            {
                writer.WritePropertyName("stormConfiguration"u8);
                writer.WriteObjectValue<object>(StormConfiguration);
            }
            if (Optional.IsDefined(YarnConfiguration))
            {
                writer.WritePropertyName("yarnConfiguration"u8);
                writer.WriteObjectValue<object>(YarnConfiguration);
            }
            if (Optional.IsDefined(EncryptedCredential))
            {
                writer.WritePropertyName("encryptedCredential"u8);
                writer.WriteObjectValue<object>(EncryptedCredential);
            }
            if (Optional.IsDefined(HeadNodeSize))
            {
                writer.WritePropertyName("headNodeSize"u8);
                writer.WriteObjectValue<object>(HeadNodeSize);
            }
            if (Optional.IsDefined(DataNodeSize))
            {
                writer.WritePropertyName("dataNodeSize"u8);
                writer.WriteObjectValue<object>(DataNodeSize);
            }
            if (Optional.IsDefined(ZookeeperNodeSize))
            {
                writer.WritePropertyName("zookeeperNodeSize"u8);
                writer.WriteObjectValue<object>(ZookeeperNodeSize);
            }
            if (Optional.IsCollectionDefined(ScriptActions))
            {
                writer.WritePropertyName("scriptActions"u8);
                writer.WriteStartArray();
                foreach (var item in ScriptActions)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(VirtualNetworkId))
            {
                writer.WritePropertyName("virtualNetworkId"u8);
                writer.WriteObjectValue<object>(VirtualNetworkId);
            }
            if (Optional.IsDefined(SubnetName))
            {
                writer.WritePropertyName("subnetName"u8);
                writer.WriteObjectValue<object>(SubnetName);
            }
            if (Optional.IsDefined(Credential))
            {
                writer.WritePropertyName("credential"u8);
                writer.WriteObjectValue(Credential);
            }
            writer.WriteEndObject();
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static HDInsightOnDemandLinkedService DeserializeHDInsightOnDemandLinkedService(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string type = default;
            IntegrationRuntimeReference connectVia = default;
            string description = default;
            IDictionary<string, ParameterSpecification> parameters = default;
            IList<object> annotations = default;
            object clusterSize = default;
            object timeToLive = default;
            object version = default;
            LinkedServiceReference linkedServiceName = default;
            object hostSubscriptionId = default;
            object servicePrincipalId = default;
            SecretBase servicePrincipalKey = default;
            object tenant = default;
            object clusterResourceGroup = default;
            object clusterNamePrefix = default;
            object clusterUserName = default;
            SecretBase clusterPassword = default;
            object clusterSshUserName = default;
            SecretBase clusterSshPassword = default;
            IList<LinkedServiceReference> additionalLinkedServiceNames = default;
            LinkedServiceReference hcatalogLinkedServiceName = default;
            object clusterType = default;
            object sparkVersion = default;
            object coreConfiguration = default;
            object hBaseConfiguration = default;
            object hdfsConfiguration = default;
            object hiveConfiguration = default;
            object mapReduceConfiguration = default;
            object oozieConfiguration = default;
            object stormConfiguration = default;
            object yarnConfiguration = default;
            object encryptedCredential = default;
            object headNodeSize = default;
            object dataNodeSize = default;
            object zookeeperNodeSize = default;
            IList<ScriptAction> scriptActions = default;
            object virtualNetworkId = default;
            object subnetName = default;
            CredentialReference credential = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("connectVia"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    connectVia = IntegrationRuntimeReference.DeserializeIntegrationRuntimeReference(property.Value);
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("parameters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, ParameterSpecification> dictionary = new Dictionary<string, ParameterSpecification>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, ParameterSpecification.DeserializeParameterSpecification(property0.Value));
                    }
                    parameters = dictionary;
                    continue;
                }
                if (property.NameEquals("annotations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<object> array = new List<object>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(item.GetObject());
                        }
                    }
                    annotations = array;
                    continue;
                }
                if (property.NameEquals("typeProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("clusterSize"u8))
                        {
                            clusterSize = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("timeToLive"u8))
                        {
                            timeToLive = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("version"u8))
                        {
                            version = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("linkedServiceName"u8))
                        {
                            linkedServiceName = LinkedServiceReference.DeserializeLinkedServiceReference(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("hostSubscriptionId"u8))
                        {
                            hostSubscriptionId = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("servicePrincipalId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            servicePrincipalId = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("servicePrincipalKey"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            servicePrincipalKey = SecretBase.DeserializeSecretBase(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("tenant"u8))
                        {
                            tenant = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("clusterResourceGroup"u8))
                        {
                            clusterResourceGroup = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("clusterNamePrefix"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterNamePrefix = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("clusterUserName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterUserName = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("clusterPassword"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterPassword = SecretBase.DeserializeSecretBase(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("clusterSshUserName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterSshUserName = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("clusterSshPassword"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterSshPassword = SecretBase.DeserializeSecretBase(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("additionalLinkedServiceNames"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<LinkedServiceReference> array = new List<LinkedServiceReference>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(LinkedServiceReference.DeserializeLinkedServiceReference(item));
                            }
                            additionalLinkedServiceNames = array;
                            continue;
                        }
                        if (property0.NameEquals("hcatalogLinkedServiceName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hcatalogLinkedServiceName = LinkedServiceReference.DeserializeLinkedServiceReference(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("clusterType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterType = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("sparkVersion"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sparkVersion = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("coreConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            coreConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("hBaseConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hBaseConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("hdfsConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hdfsConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("hiveConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            hiveConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("mapReduceConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            mapReduceConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("oozieConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            oozieConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("stormConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            stormConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("yarnConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            yarnConfiguration = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("encryptedCredential"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            encryptedCredential = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("headNodeSize"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            headNodeSize = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("dataNodeSize"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dataNodeSize = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("zookeeperNodeSize"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            zookeeperNodeSize = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("scriptActions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ScriptAction> array = new List<ScriptAction>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(ScriptAction.DeserializeScriptAction(item));
                            }
                            scriptActions = array;
                            continue;
                        }
                        if (property0.NameEquals("virtualNetworkId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            virtualNetworkId = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("subnetName"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            subnetName = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("credential"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            credential = CredentialReference.DeserializeCredentialReference(property0.Value);
                            continue;
                        }
                    }
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new HDInsightOnDemandLinkedService(
                type,
                connectVia,
                description,
                parameters ?? new ChangeTrackingDictionary<string, ParameterSpecification>(),
                annotations ?? new ChangeTrackingList<object>(),
                additionalProperties,
                clusterSize,
                timeToLive,
                version,
                linkedServiceName,
                hostSubscriptionId,
                servicePrincipalId,
                servicePrincipalKey,
                tenant,
                clusterResourceGroup,
                clusterNamePrefix,
                clusterUserName,
                clusterPassword,
                clusterSshUserName,
                clusterSshPassword,
                additionalLinkedServiceNames ?? new ChangeTrackingList<LinkedServiceReference>(),
                hcatalogLinkedServiceName,
                clusterType,
                sparkVersion,
                coreConfiguration,
                hBaseConfiguration,
                hdfsConfiguration,
                hiveConfiguration,
                mapReduceConfiguration,
                oozieConfiguration,
                stormConfiguration,
                yarnConfiguration,
                encryptedCredential,
                headNodeSize,
                dataNodeSize,
                zookeeperNodeSize,
                scriptActions ?? new ChangeTrackingList<ScriptAction>(),
                virtualNetworkId,
                subnetName,
                credential);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new HDInsightOnDemandLinkedService FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHDInsightOnDemandLinkedService(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class HDInsightOnDemandLinkedServiceConverter : JsonConverter<HDInsightOnDemandLinkedService>
        {
            public override void Write(Utf8JsonWriter writer, HDInsightOnDemandLinkedService model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override HDInsightOnDemandLinkedService Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeHDInsightOnDemandLinkedService(document.RootElement);
            }
        }
    }
}
