// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> HDInsight linked service. </summary>
    public partial class HDInsightLinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="HDInsightLinkedService"/>. </summary>
        /// <param name="clusterUri"> HDInsight cluster URI. Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clusterUri"/> is null. </exception>
        public HDInsightLinkedService(object clusterUri)
        {
            Argument.AssertNotNull(clusterUri, nameof(clusterUri));

            ClusterUri = clusterUri;
            Type = "HDInsight";
        }

        /// <summary> Initializes a new instance of <see cref="HDInsightLinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="clusterUri"> HDInsight cluster URI. Type: string (or Expression with resultType string). </param>
        /// <param name="userName"> HDInsight cluster user name. Type: string (or Expression with resultType string). </param>
        /// <param name="password">
        /// HDInsight cluster password.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="linkedServiceName"> The Azure Storage linked service reference. </param>
        /// <param name="hcatalogLinkedServiceName"> A reference to the Azure SQL linked service that points to the HCatalog database. </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </param>
        /// <param name="isEspEnabled"> Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean. </param>
        /// <param name="fileSystem"> Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string). </param>
        internal HDInsightLinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, object clusterUri, object userName, SecretBase password, LinkedServiceReference linkedServiceName, LinkedServiceReference hcatalogLinkedServiceName, object encryptedCredential, object isEspEnabled, object fileSystem) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            ClusterUri = clusterUri;
            UserName = userName;
            Password = password;
            LinkedServiceName = linkedServiceName;
            HcatalogLinkedServiceName = hcatalogLinkedServiceName;
            EncryptedCredential = encryptedCredential;
            IsEspEnabled = isEspEnabled;
            FileSystem = fileSystem;
            Type = type ?? "HDInsight";
        }

        /// <summary> HDInsight cluster URI. Type: string (or Expression with resultType string). </summary>
        public object ClusterUri { get; set; }
        /// <summary> HDInsight cluster user name. Type: string (or Expression with resultType string). </summary>
        public object UserName { get; set; }
        /// <summary>
        /// HDInsight cluster password.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase Password { get; set; }
        /// <summary> The Azure Storage linked service reference. </summary>
        public LinkedServiceReference LinkedServiceName { get; set; }
        /// <summary> A reference to the Azure SQL linked service that points to the HCatalog database. </summary>
        public LinkedServiceReference HcatalogLinkedServiceName { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </summary>
        public object EncryptedCredential { get; set; }
        /// <summary> Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean. </summary>
        public object IsEspEnabled { get; set; }
        /// <summary> Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType string). </summary>
        public object FileSystem { get; set; }
    }
}
