// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Google BigQuery service linked service. </summary>
    public partial class GoogleBigQueryV2LinkedService : LinkedService
    {
        /// <summary> Initializes a new instance of <see cref="GoogleBigQueryV2LinkedService"/>. </summary>
        /// <param name="projectId"> The default BigQuery project id to query against. </param>
        /// <param name="authenticationType"> The OAuth 2.0 authentication mechanism used for authentication. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="projectId"/> is null. </exception>
        public GoogleBigQueryV2LinkedService(object projectId, GoogleBigQueryV2AuthenticationType authenticationType)
        {
            Argument.AssertNotNull(projectId, nameof(projectId));

            ProjectId = projectId;
            AuthenticationType = authenticationType;
            Type = "GoogleBigQueryV2";
        }

        /// <summary> Initializes a new instance of <see cref="GoogleBigQueryV2LinkedService"/>. </summary>
        /// <param name="type"> Type of linked service. </param>
        /// <param name="connectVia"> The integration runtime reference. </param>
        /// <param name="description"> Linked service description. </param>
        /// <param name="parameters"> Parameters for linked service. </param>
        /// <param name="annotations"> List of tags that can be used for describing the linked service. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="projectId"> The default BigQuery project id to query against. </param>
        /// <param name="authenticationType"> The OAuth 2.0 authentication mechanism used for authentication. </param>
        /// <param name="clientId"> The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string). </param>
        /// <param name="clientSecret">
        /// The client secret of the google application used to acquire the refresh token.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="refreshToken">
        /// The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="keyFileContent">
        /// The content of the .json key file that is used to authenticate the service account.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </param>
        /// <param name="encryptedCredential"> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </param>
        internal GoogleBigQueryV2LinkedService(string type, IntegrationRuntimeReference connectVia, string description, IDictionary<string, ParameterSpecification> parameters, IList<object> annotations, IDictionary<string, object> additionalProperties, object projectId, GoogleBigQueryV2AuthenticationType authenticationType, object clientId, SecretBase clientSecret, SecretBase refreshToken, SecretBase keyFileContent, string encryptedCredential) : base(type, connectVia, description, parameters, annotations, additionalProperties)
        {
            ProjectId = projectId;
            AuthenticationType = authenticationType;
            ClientId = clientId;
            ClientSecret = clientSecret;
            RefreshToken = refreshToken;
            KeyFileContent = keyFileContent;
            EncryptedCredential = encryptedCredential;
            Type = type ?? "GoogleBigQueryV2";
        }

        /// <summary> The default BigQuery project id to query against. </summary>
        public object ProjectId { get; set; }
        /// <summary> The OAuth 2.0 authentication mechanism used for authentication. </summary>
        public GoogleBigQueryV2AuthenticationType AuthenticationType { get; set; }
        /// <summary> The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string). </summary>
        public object ClientId { get; set; }
        /// <summary>
        /// The client secret of the google application used to acquire the refresh token.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase ClientSecret { get; set; }
        /// <summary>
        /// The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase RefreshToken { get; set; }
        /// <summary>
        /// The content of the .json key file that is used to authenticate the service account.
        /// Please note <see cref="SecretBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="AzureKeyVaultSecretReference"/> and <see cref="SecureString"/>.
        /// </summary>
        public SecretBase KeyFileContent { get; set; }
        /// <summary> The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string (or Expression with resultType string). </summary>
        public string EncryptedCredential { get; set; }
    }
}
