// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(GitHubAccessTokenResponseConverter))]
    public partial class GitHubAccessTokenResponse
    {
        internal static GitHubAccessTokenResponse DeserializeGitHubAccessTokenResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string gitHubAccessToken = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("gitHubAccessToken"u8))
                {
                    gitHubAccessToken = property.Value.GetString();
                    continue;
                }
            }
            return new GitHubAccessTokenResponse(gitHubAccessToken);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static GitHubAccessTokenResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeGitHubAccessTokenResponse(document.RootElement);
        }

        internal partial class GitHubAccessTokenResponseConverter : JsonConverter<GitHubAccessTokenResponse>
        {
            public override void Write(Utf8JsonWriter writer, GitHubAccessTokenResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override GitHubAccessTokenResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeGitHubAccessTokenResponse(document.RootElement);
            }
        }
    }
}
