// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(GitHubAccessTokenRequestConverter))]
    public partial class GitHubAccessTokenRequest : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("gitHubClientId"u8);
            writer.WriteStringValue(GitHubClientId);
            writer.WritePropertyName("gitHubAccessCode"u8);
            writer.WriteStringValue(GitHubAccessCode);
            writer.WritePropertyName("gitHubAccessTokenBaseUrl"u8);
            writer.WriteStringValue(GitHubAccessTokenBaseUrl);
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class GitHubAccessTokenRequestConverter : JsonConverter<GitHubAccessTokenRequest>
        {
            public override void Write(Utf8JsonWriter writer, GitHubAccessTokenRequest model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override GitHubAccessTokenRequest Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }
        }
    }
}
