// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Filter and return results from input array based on the conditions. </summary>
    public partial class FilterActivity : ControlActivity
    {
        /// <summary> Initializes a new instance of <see cref="FilterActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="items"> Input array on which filter should be applied. </param>
        /// <param name="condition"> Condition to be used for filtering the input. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="items"/> or <paramref name="condition"/> is null. </exception>
        public FilterActivity(string name, Expression items, Expression condition) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(items, nameof(items));
            Argument.AssertNotNull(condition, nameof(condition));

            Items = items;
            Condition = condition;
            Type = "Filter";
        }

        /// <summary> Initializes a new instance of <see cref="FilterActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="type"> Type of activity. </param>
        /// <param name="description"> Activity description. </param>
        /// <param name="state"> Activity state. This is an optional property and if not provided, the state will be Active by default. </param>
        /// <param name="onInactiveMarkAs"> Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default. </param>
        /// <param name="dependsOn"> Activity depends on condition. </param>
        /// <param name="userProperties"> Activity user properties. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="items"> Input array on which filter should be applied. </param>
        /// <param name="condition"> Condition to be used for filtering the input. </param>
        internal FilterActivity(string name, string type, string description, ActivityState? state, ActivityOnInactiveMarkAs? onInactiveMarkAs, IList<ActivityDependency> dependsOn, IList<UserProperty> userProperties, IDictionary<string, object> additionalProperties, Expression items, Expression condition) : base(name, type, description, state, onInactiveMarkAs, dependsOn, userProperties, additionalProperties)
        {
            Items = items;
            Condition = condition;
            Type = type ?? "Filter";
        }

        /// <summary> Input array on which filter should be applied. </summary>
        public Expression Items { get; set; }
        /// <summary> Condition to be used for filtering the input. </summary>
        public Expression Condition { get; set; }
    }
}
