// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Type of expressions supported by the system. Type: string. </summary>
    public readonly partial struct ExpressionV2Type : IEquatable<ExpressionV2Type>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExpressionV2Type"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExpressionV2Type(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConstantValue = "Constant";
        private const string FieldValue = "Field";
        private const string UnaryValue = "Unary";
        private const string BinaryValue = "Binary";

        /// <summary> Constant. </summary>
        public static ExpressionV2Type Constant { get; } = new ExpressionV2Type(ConstantValue);
        /// <summary> Field. </summary>
        public static ExpressionV2Type Field { get; } = new ExpressionV2Type(FieldValue);
        /// <summary> Unary. </summary>
        public static ExpressionV2Type Unary { get; } = new ExpressionV2Type(UnaryValue);
        /// <summary> Binary. </summary>
        public static ExpressionV2Type Binary { get; } = new ExpressionV2Type(BinaryValue);
        /// <summary> Determines if two <see cref="ExpressionV2Type"/> values are the same. </summary>
        public static bool operator ==(ExpressionV2Type left, ExpressionV2Type right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExpressionV2Type"/> values are not the same. </summary>
        public static bool operator !=(ExpressionV2Type left, ExpressionV2Type right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExpressionV2Type"/>. </summary>
        public static implicit operator ExpressionV2Type(string value) => new ExpressionV2Type(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExpressionV2Type other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExpressionV2Type other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
