// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Nested representation of a complex expression. </summary>
    public partial class ExpressionV2
    {
        /// <summary> Initializes a new instance of <see cref="ExpressionV2"/>. </summary>
        public ExpressionV2()
        {
            Operands = new ChangeTrackingList<ExpressionV2>();
        }

        /// <summary> Initializes a new instance of <see cref="ExpressionV2"/>. </summary>
        /// <param name="type"> Type of expressions supported by the system. Type: string. </param>
        /// <param name="value"> Value for Constant/Field Type: string. </param>
        /// <param name="operator"> Expression operator value Type: string. </param>
        /// <param name="operands"> List of nested expressions. </param>
        internal ExpressionV2(ExpressionV2Type? type, string value, string @operator, IList<ExpressionV2> operands)
        {
            Type = type;
            Value = value;
            Operator = @operator;
            Operands = operands;
        }

        /// <summary> Type of expressions supported by the system. Type: string. </summary>
        public ExpressionV2Type? Type { get; set; }
        /// <summary> Value for Constant/Field Type: string. </summary>
        public string Value { get; set; }
        /// <summary> Expression operator value Type: string. </summary>
        public string Operator { get; set; }
        /// <summary> List of nested expressions. </summary>
        public IList<ExpressionV2> Operands { get; }
    }
}
