// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Execute pipeline activity. </summary>
    public partial class ExecutePipelineActivity : ControlActivity
    {
        /// <summary> Initializes a new instance of <see cref="ExecutePipelineActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="pipeline"> Pipeline reference. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="pipeline"/> is null. </exception>
        public ExecutePipelineActivity(string name, PipelineReference pipeline) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(pipeline, nameof(pipeline));

            Pipeline = pipeline;
            Parameters = new ChangeTrackingDictionary<string, object>();
            Type = "ExecutePipeline";
        }

        /// <summary> Initializes a new instance of <see cref="ExecutePipelineActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="type"> Type of activity. </param>
        /// <param name="description"> Activity description. </param>
        /// <param name="state"> Activity state. This is an optional property and if not provided, the state will be Active by default. </param>
        /// <param name="onInactiveMarkAs"> Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default. </param>
        /// <param name="dependsOn"> Activity depends on condition. </param>
        /// <param name="userProperties"> Activity user properties. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="pipeline"> Pipeline reference. </param>
        /// <param name="parameters"> Pipeline parameters. </param>
        /// <param name="waitOnCompletion"> Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false. </param>
        internal ExecutePipelineActivity(string name, string type, string description, ActivityState? state, ActivityOnInactiveMarkAs? onInactiveMarkAs, IList<ActivityDependency> dependsOn, IList<UserProperty> userProperties, IDictionary<string, object> additionalProperties, PipelineReference pipeline, IDictionary<string, object> parameters, bool? waitOnCompletion) : base(name, type, description, state, onInactiveMarkAs, dependsOn, userProperties, additionalProperties)
        {
            Pipeline = pipeline;
            Parameters = parameters;
            WaitOnCompletion = waitOnCompletion;
            Type = type ?? "ExecutePipeline";
        }

        /// <summary> Pipeline reference. </summary>
        public PipelineReference Pipeline { get; set; }
        /// <summary> Pipeline parameters. </summary>
        public IDictionary<string, object> Parameters { get; }
        /// <summary> Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false. </summary>
        public bool? WaitOnCompletion { get; set; }
    }
}
