// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Compute properties for data flow activity. </summary>
    public partial class ExecuteDataFlowActivityTypePropertiesCompute
    {
        /// <summary> Initializes a new instance of <see cref="ExecuteDataFlowActivityTypePropertiesCompute"/>. </summary>
        public ExecuteDataFlowActivityTypePropertiesCompute()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ExecuteDataFlowActivityTypePropertiesCompute"/>. </summary>
        /// <param name="computeType"> Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression with resultType string). </param>
        /// <param name="coreCount"> Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer). </param>
        internal ExecuteDataFlowActivityTypePropertiesCompute(object computeType, object coreCount)
        {
            ComputeType = computeType;
            CoreCount = coreCount;
        }

        /// <summary> Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'. Type: string (or Expression with resultType string). </summary>
        public object ComputeType { get; set; }
        /// <summary> Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type: integer (or Expression with resultType integer). </summary>
        public object CoreCount { get; set; }
    }
}
