// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Execute data flow activity. </summary>
    public partial class ExecuteDataFlowActivity : ExecutionActivity
    {
        /// <summary> Initializes a new instance of <see cref="ExecuteDataFlowActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="dataflow"> Data flow reference. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="dataflow"/> is null. </exception>
        public ExecuteDataFlowActivity(string name, DataFlowReference dataflow) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(dataflow, nameof(dataflow));

            Dataflow = dataflow;
            Type = "ExecuteDataFlow";
        }

        /// <summary> Initializes a new instance of <see cref="ExecuteDataFlowActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="type"> Type of activity. </param>
        /// <param name="description"> Activity description. </param>
        /// <param name="state"> Activity state. This is an optional property and if not provided, the state will be Active by default. </param>
        /// <param name="onInactiveMarkAs"> Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default. </param>
        /// <param name="dependsOn"> Activity depends on condition. </param>
        /// <param name="userProperties"> Activity user properties. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="linkedServiceName"> Linked service reference. </param>
        /// <param name="policy"> Activity policy. </param>
        /// <param name="dataflow"> Data flow reference. </param>
        /// <param name="staging"> Staging info for execute data flow activity. </param>
        /// <param name="integrationRuntime"> The integration runtime reference. </param>
        /// <param name="compute"> Compute properties for data flow activity. </param>
        /// <param name="traceLevel"> Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string). </param>
        /// <param name="continueOnError"> Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="runConcurrently"> Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="sourceStagingConcurrency"> Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer). </param>
        internal ExecuteDataFlowActivity(string name, string type, string description, ActivityState? state, ActivityOnInactiveMarkAs? onInactiveMarkAs, IList<ActivityDependency> dependsOn, IList<UserProperty> userProperties, IDictionary<string, object> additionalProperties, LinkedServiceReference linkedServiceName, ActivityPolicy policy, DataFlowReference dataflow, DataFlowStagingInfo staging, IntegrationRuntimeReference integrationRuntime, ExecuteDataFlowActivityTypePropertiesCompute compute, object traceLevel, object continueOnError, object runConcurrently, object sourceStagingConcurrency) : base(name, type, description, state, onInactiveMarkAs, dependsOn, userProperties, additionalProperties, linkedServiceName, policy)
        {
            Dataflow = dataflow;
            Staging = staging;
            IntegrationRuntime = integrationRuntime;
            Compute = compute;
            TraceLevel = traceLevel;
            ContinueOnError = continueOnError;
            RunConcurrently = runConcurrently;
            SourceStagingConcurrency = sourceStagingConcurrency;
            Type = type ?? "ExecuteDataFlow";
        }

        /// <summary> Data flow reference. </summary>
        public DataFlowReference Dataflow { get; set; }
        /// <summary> Staging info for execute data flow activity. </summary>
        public DataFlowStagingInfo Staging { get; set; }
        /// <summary> The integration runtime reference. </summary>
        public IntegrationRuntimeReference IntegrationRuntime { get; set; }
        /// <summary> Compute properties for data flow activity. </summary>
        public ExecuteDataFlowActivityTypePropertiesCompute Compute { get; set; }
        /// <summary> Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string (or Expression with resultType string). </summary>
        public object TraceLevel { get; set; }
        /// <summary> Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or Expression with resultType boolean). </summary>
        public object ContinueOnError { get; set; }
        /// <summary> Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently. Type: boolean (or Expression with resultType boolean). </summary>
        public object RunConcurrently { get; set; }
        /// <summary> Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer). </summary>
        public object SourceStagingConcurrency { get; set; }
    }
}
