// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(DistcpSettingsConverter))]
    public partial class DistcpSettings : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("resourceManagerEndpoint"u8);
            writer.WriteObjectValue<object>(ResourceManagerEndpoint);
            writer.WritePropertyName("tempScriptPath"u8);
            writer.WriteObjectValue<object>(TempScriptPath);
            if (Optional.IsDefined(DistcpOptions))
            {
                writer.WritePropertyName("distcpOptions"u8);
                writer.WriteObjectValue<object>(DistcpOptions);
            }
            writer.WriteEndObject();
        }

        internal static DistcpSettings DeserializeDistcpSettings(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            object resourceManagerEndpoint = default;
            object tempScriptPath = default;
            object distcpOptions = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resourceManagerEndpoint"u8))
                {
                    resourceManagerEndpoint = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("tempScriptPath"u8))
                {
                    tempScriptPath = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("distcpOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    distcpOptions = property.Value.GetObject();
                    continue;
                }
            }
            return new DistcpSettings(resourceManagerEndpoint, tempScriptPath, distcpOptions);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DistcpSettings FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDistcpSettings(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class DistcpSettingsConverter : JsonConverter<DistcpSettings>
        {
            public override void Write(Utf8JsonWriter writer, DistcpSettings model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override DistcpSettings Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeDistcpSettings(document.RootElement);
            }
        }
    }
}
