// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Columns that define the physical type schema of the dataset. </summary>
    public partial class DatasetSchemaDataElement
    {
        /// <summary> Initializes a new instance of <see cref="DatasetSchemaDataElement"/>. </summary>
        public DatasetSchemaDataElement()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="DatasetSchemaDataElement"/>. </summary>
        /// <param name="name"> Name of the schema column. Type: string (or Expression with resultType string). </param>
        /// <param name="type"> Type of the schema column. Type: string (or Expression with resultType string). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal DatasetSchemaDataElement(object name, object type, IDictionary<string, object> additionalProperties)
        {
            Name = name;
            Type = type;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Name of the schema column. Type: string (or Expression with resultType string). </summary>
        public object Name { get; set; }
        /// <summary> Type of the schema column. Type: string (or Expression with resultType string). </summary>
        public object Type { get; set; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
