// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Dataset reference type. </summary>
    public readonly partial struct DatasetReferenceType : IEquatable<DatasetReferenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DatasetReferenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DatasetReferenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DatasetReferenceValue = "DatasetReference";

        /// <summary> DatasetReference. </summary>
        public static DatasetReferenceType DatasetReference { get; } = new DatasetReferenceType(DatasetReferenceValue);
        /// <summary> Determines if two <see cref="DatasetReferenceType"/> values are the same. </summary>
        public static bool operator ==(DatasetReferenceType left, DatasetReferenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DatasetReferenceType"/> values are not the same. </summary>
        public static bool operator !=(DatasetReferenceType left, DatasetReferenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DatasetReferenceType"/>. </summary>
        public static implicit operator DatasetReferenceType(string value) => new DatasetReferenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DatasetReferenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DatasetReferenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
