// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The DatasetCompressionLevel. </summary>
    internal readonly partial struct DatasetCompressionLevel : IEquatable<DatasetCompressionLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DatasetCompressionLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DatasetCompressionLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OptimalValue = "Optimal";
        private const string FastestValue = "Fastest";

        /// <summary> Optimal. </summary>
        public static DatasetCompressionLevel Optimal { get; } = new DatasetCompressionLevel(OptimalValue);
        /// <summary> Fastest. </summary>
        public static DatasetCompressionLevel Fastest { get; } = new DatasetCompressionLevel(FastestValue);
        /// <summary> Determines if two <see cref="DatasetCompressionLevel"/> values are the same. </summary>
        public static bool operator ==(DatasetCompressionLevel left, DatasetCompressionLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DatasetCompressionLevel"/> values are not the same. </summary>
        public static bool operator !=(DatasetCompressionLevel left, DatasetCompressionLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DatasetCompressionLevel"/>. </summary>
        public static implicit operator DatasetCompressionLevel(string value) => new DatasetCompressionLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DatasetCompressionLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DatasetCompressionLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
