// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Definition of data flow source setting for debug. </summary>
    public partial class DataFlowSourceSetting
    {
        /// <summary> Initializes a new instance of <see cref="DataFlowSourceSetting"/>. </summary>
        public DataFlowSourceSetting()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="DataFlowSourceSetting"/>. </summary>
        /// <param name="sourceName"> The data flow source name. </param>
        /// <param name="rowLimit"> Defines the row limit of data flow source in debug. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal DataFlowSourceSetting(string sourceName, int? rowLimit, IDictionary<string, object> additionalProperties)
        {
            SourceName = sourceName;
            RowLimit = rowLimit;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The data flow source name. </summary>
        public string SourceName { get; set; }
        /// <summary> Defines the row limit of data flow source in debug. </summary>
        public int? RowLimit { get; set; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
