// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Transformation for data flow sink. </summary>
    public partial class DataFlowSink : Transformation
    {
        /// <summary> Initializes a new instance of <see cref="DataFlowSink"/>. </summary>
        /// <param name="name"> Transformation name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public DataFlowSink(string name) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));
        }

        /// <summary> Initializes a new instance of <see cref="DataFlowSink"/>. </summary>
        /// <param name="name"> Transformation name. </param>
        /// <param name="description"> Transformation description. </param>
        /// <param name="dataset"> Dataset reference. </param>
        /// <param name="linkedService"> Linked service reference. </param>
        /// <param name="flowlet"> Flowlet Reference. </param>
        /// <param name="schemaLinkedService"> Schema linked service reference. </param>
        /// <param name="rejectedDataLinkedService"> Rejected data linked service reference. </param>
        internal DataFlowSink(string name, string description, DatasetReference dataset, LinkedServiceReference linkedService, DataFlowReference flowlet, LinkedServiceReference schemaLinkedService, LinkedServiceReference rejectedDataLinkedService) : base(name, description, dataset, linkedService, flowlet)
        {
            SchemaLinkedService = schemaLinkedService;
            RejectedDataLinkedService = rejectedDataLinkedService;
        }

        /// <summary> Schema linked service reference. </summary>
        public LinkedServiceReference SchemaLinkedService { get; set; }
        /// <summary> Rejected data linked service reference. </summary>
        public LinkedServiceReference RejectedDataLinkedService { get; set; }
    }
}
