// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Data flow resource type. </summary>
    public partial class DataFlowResource : SubResource
    {
        /// <summary> Initializes a new instance of <see cref="DataFlowResource"/>. </summary>
        /// <param name="properties">
        /// Data flow properties.
        /// Please note <see cref="DataFlow"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Flowlet"/> and <see cref="MappingDataFlow"/>.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public DataFlowResource(DataFlow properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
        }

        /// <summary> Initializes a new instance of <see cref="DataFlowResource"/>. </summary>
        /// <param name="id"> Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}. </param>
        /// <param name="name"> The name of the resource. </param>
        /// <param name="type"> The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="properties">
        /// Data flow properties.
        /// Please note <see cref="DataFlow"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Flowlet"/> and <see cref="MappingDataFlow"/>.
        /// </param>
        internal DataFlowResource(string id, string name, string type, string etag, DataFlow properties) : base(id, name, type, etag)
        {
            Properties = properties;
        }

        /// <summary>
        /// Data flow properties.
        /// Please note <see cref="DataFlow"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Flowlet"/> and <see cref="MappingDataFlow"/>.
        /// </summary>
        public DataFlow Properties { get; set; }
    }
}
