// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Data flow reference type. </summary>
    public partial class DataFlowReference
    {
        /// <summary> Initializes a new instance of <see cref="DataFlowReference"/>. </summary>
        /// <param name="type"> Data flow reference type. </param>
        /// <param name="referenceName"> Reference data flow name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="referenceName"/> is null. </exception>
        public DataFlowReference(DataFlowReferenceType type, string referenceName)
        {
            Argument.AssertNotNull(referenceName, nameof(referenceName));

            Type = type;
            ReferenceName = referenceName;
            Parameters = new ChangeTrackingDictionary<string, object>();
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="DataFlowReference"/>. </summary>
        /// <param name="type"> Data flow reference type. </param>
        /// <param name="referenceName"> Reference data flow name. </param>
        /// <param name="datasetParameters"> Reference data flow parameters from dataset. </param>
        /// <param name="parameters"> Data flow parameters. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal DataFlowReference(DataFlowReferenceType type, string referenceName, object datasetParameters, IDictionary<string, object> parameters, IDictionary<string, object> additionalProperties)
        {
            Type = type;
            ReferenceName = referenceName;
            DatasetParameters = datasetParameters;
            Parameters = parameters;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Data flow reference type. </summary>
        public DataFlowReferenceType Type { get; set; }
        /// <summary> Reference data flow name. </summary>
        public string ReferenceName { get; set; }
        /// <summary> Reference data flow parameters from dataset. </summary>
        public object DatasetParameters { get; set; }
        /// <summary> Data flow parameters. </summary>
        public IDictionary<string, object> Parameters { get; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
