// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(DataFlowListResponseConverter))]
    internal partial class DataFlowListResponse
    {
        internal static DataFlowListResponse DeserializeDataFlowListResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<DataFlowResource> value = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<DataFlowResource> array = new List<DataFlowResource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DataFlowResource.DeserializeDataFlowResource(item));
                    }
                    value = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new DataFlowListResponse(value, nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DataFlowListResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDataFlowListResponse(document.RootElement);
        }

        internal partial class DataFlowListResponseConverter : JsonConverter<DataFlowListResponse>
        {
            public override void Write(Utf8JsonWriter writer, DataFlowListResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override DataFlowListResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeDataFlowListResponse(document.RootElement);
            }
        }
    }
}
