// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Data flow debug session info. </summary>
    public partial class DataFlowDebugSessionInfo
    {
        /// <summary> Initializes a new instance of <see cref="DataFlowDebugSessionInfo"/>. </summary>
        internal DataFlowDebugSessionInfo()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="DataFlowDebugSessionInfo"/>. </summary>
        /// <param name="dataFlowName"> The name of the data flow. </param>
        /// <param name="computeType"> Compute type of the cluster. </param>
        /// <param name="coreCount"> Core count of the cluster. </param>
        /// <param name="nodeCount"> Node count of the cluster. (deprecated property). </param>
        /// <param name="integrationRuntimeName"> Attached integration runtime name of data flow debug session. </param>
        /// <param name="sessionId"> The ID of data flow debug session. </param>
        /// <param name="startTime"> Start time of data flow debug session. </param>
        /// <param name="timeToLiveInMinutes"> Compute type of the cluster. </param>
        /// <param name="lastActivityTime"> Last activity time of data flow debug session. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal DataFlowDebugSessionInfo(string dataFlowName, string computeType, int? coreCount, int? nodeCount, string integrationRuntimeName, string sessionId, string startTime, int? timeToLiveInMinutes, string lastActivityTime, IReadOnlyDictionary<string, object> additionalProperties)
        {
            DataFlowName = dataFlowName;
            ComputeType = computeType;
            CoreCount = coreCount;
            NodeCount = nodeCount;
            IntegrationRuntimeName = integrationRuntimeName;
            SessionId = sessionId;
            StartTime = startTime;
            TimeToLiveInMinutes = timeToLiveInMinutes;
            LastActivityTime = lastActivityTime;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The name of the data flow. </summary>
        public string DataFlowName { get; }
        /// <summary> Compute type of the cluster. </summary>
        public string ComputeType { get; }
        /// <summary> Core count of the cluster. </summary>
        public int? CoreCount { get; }
        /// <summary> Node count of the cluster. (deprecated property). </summary>
        public int? NodeCount { get; }
        /// <summary> Attached integration runtime name of data flow debug session. </summary>
        public string IntegrationRuntimeName { get; }
        /// <summary> The ID of data flow debug session. </summary>
        public string SessionId { get; }
        /// <summary> Start time of data flow debug session. </summary>
        public string StartTime { get; }
        /// <summary> Compute type of the cluster. </summary>
        public int? TimeToLiveInMinutes { get; }
        /// <summary> Last activity time of data flow debug session. </summary>
        public string LastActivityTime { get; }
        /// <summary> Additional Properties. </summary>
        public IReadOnlyDictionary<string, object> AdditionalProperties { get; }
    }
}
