// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Custom activity type. </summary>
    public partial class CustomActivity : ExecutionActivity
    {
        /// <summary> Initializes a new instance of <see cref="CustomActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="command"> Command for custom activity Type: string (or Expression with resultType string). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="command"/> is null. </exception>
        public CustomActivity(string name, object command) : base(name)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(command, nameof(command));

            Command = command;
            ExtendedProperties = new ChangeTrackingDictionary<string, object>();
            Type = "Custom";
        }

        /// <summary> Initializes a new instance of <see cref="CustomActivity"/>. </summary>
        /// <param name="name"> Activity name. </param>
        /// <param name="type"> Type of activity. </param>
        /// <param name="description"> Activity description. </param>
        /// <param name="state"> Activity state. This is an optional property and if not provided, the state will be Active by default. </param>
        /// <param name="onInactiveMarkAs"> Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default. </param>
        /// <param name="dependsOn"> Activity depends on condition. </param>
        /// <param name="userProperties"> Activity user properties. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="linkedServiceName"> Linked service reference. </param>
        /// <param name="policy"> Activity policy. </param>
        /// <param name="command"> Command for custom activity Type: string (or Expression with resultType string). </param>
        /// <param name="resourceLinkedService"> Resource linked service reference. </param>
        /// <param name="folderPath"> Folder path for resource files Type: string (or Expression with resultType string). </param>
        /// <param name="referenceObjects"> Reference objects. </param>
        /// <param name="extendedProperties"> User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined. </param>
        /// <param name="retentionTimeInDays"> The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double). </param>
        /// <param name="autoUserSpecification"> Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double). </param>
        internal CustomActivity(string name, string type, string description, ActivityState? state, ActivityOnInactiveMarkAs? onInactiveMarkAs, IList<ActivityDependency> dependsOn, IList<UserProperty> userProperties, IDictionary<string, object> additionalProperties, LinkedServiceReference linkedServiceName, ActivityPolicy policy, object command, LinkedServiceReference resourceLinkedService, object folderPath, CustomActivityReferenceObject referenceObjects, IDictionary<string, object> extendedProperties, object retentionTimeInDays, object autoUserSpecification) : base(name, type, description, state, onInactiveMarkAs, dependsOn, userProperties, additionalProperties, linkedServiceName, policy)
        {
            Command = command;
            ResourceLinkedService = resourceLinkedService;
            FolderPath = folderPath;
            ReferenceObjects = referenceObjects;
            ExtendedProperties = extendedProperties;
            RetentionTimeInDays = retentionTimeInDays;
            AutoUserSpecification = autoUserSpecification;
            Type = type ?? "Custom";
        }

        /// <summary> Command for custom activity Type: string (or Expression with resultType string). </summary>
        public object Command { get; set; }
        /// <summary> Resource linked service reference. </summary>
        public LinkedServiceReference ResourceLinkedService { get; set; }
        /// <summary> Folder path for resource files Type: string (or Expression with resultType string). </summary>
        public object FolderPath { get; set; }
        /// <summary> Reference objects. </summary>
        public CustomActivityReferenceObject ReferenceObjects { get; set; }
        /// <summary> User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined. </summary>
        public IDictionary<string, object> ExtendedProperties { get; }
        /// <summary> The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double). </summary>
        public object RetentionTimeInDays { get; set; }
        /// <summary> Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double). </summary>
        public object AutoUserSpecification { get; set; }
    }
}
