// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Credential reference type. </summary>
    public readonly partial struct CredentialReferenceType : IEquatable<CredentialReferenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CredentialReferenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CredentialReferenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CredentialReferenceValue = "CredentialReference";

        /// <summary> CredentialReference. </summary>
        public static CredentialReferenceType CredentialReference { get; } = new CredentialReferenceType(CredentialReferenceValue);
        /// <summary> Determines if two <see cref="CredentialReferenceType"/> values are the same. </summary>
        public static bool operator ==(CredentialReferenceType left, CredentialReferenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CredentialReferenceType"/> values are not the same. </summary>
        public static bool operator !=(CredentialReferenceType left, CredentialReferenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CredentialReferenceType"/>. </summary>
        public static implicit operator CredentialReferenceType(string value) => new CredentialReferenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CredentialReferenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CredentialReferenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
