// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(CreateRunResponseConverter))]
    public partial class CreateRunResponse
    {
        internal static CreateRunResponse DeserializeCreateRunResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string runId = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("runId"u8))
                {
                    runId = property.Value.GetString();
                    continue;
                }
            }
            return new CreateRunResponse(runId);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CreateRunResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCreateRunResponse(document.RootElement);
        }

        internal partial class CreateRunResponseConverter : JsonConverter<CreateRunResponse>
        {
            public override void Write(Utf8JsonWriter writer, CreateRunResponse model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override CreateRunResponse Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeCreateRunResponse(document.RootElement);
            }
        }
    }
}
