// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary>
    /// Specifies the mode of sql pool creation.
    ///
    /// Default: regular sql pool creation.
    ///
    /// PointInTimeRestore: Creates a sql pool by restoring a point in time backup of an existing sql pool. sourceDatabaseId must be specified as the resource ID of the existing sql pool, and restorePointInTime must be specified.
    ///
    /// Recovery: Creates a sql pool by a geo-replicated backup. sourceDatabaseId  must be specified as the recoverableDatabaseId to restore.
    ///
    /// Restore: Creates a sql pool by restoring a backup of a deleted sql  pool. SourceDatabaseId should be the sql pool's original resource ID. SourceDatabaseId and sourceDatabaseDeletionDate must be specified.
    /// </summary>
    public readonly partial struct CreateMode : IEquatable<CreateMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CreateMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CreateMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string PointInTimeRestoreValue = "PointInTimeRestore";
        private const string RecoveryValue = "Recovery";
        private const string RestoreValue = "Restore";

        /// <summary> Default. </summary>
        public static CreateMode Default { get; } = new CreateMode(DefaultValue);
        /// <summary> PointInTimeRestore. </summary>
        public static CreateMode PointInTimeRestore { get; } = new CreateMode(PointInTimeRestoreValue);
        /// <summary> Recovery. </summary>
        public static CreateMode Recovery { get; } = new CreateMode(RecoveryValue);
        /// <summary> Restore. </summary>
        public static CreateMode Restore { get; } = new CreateMode(RestoreValue);
        /// <summary> Determines if two <see cref="CreateMode"/> values are the same. </summary>
        public static bool operator ==(CreateMode left, CreateMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CreateMode"/> values are not the same. </summary>
        public static bool operator !=(CreateMode left, CreateMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CreateMode"/>. </summary>
        public static implicit operator CreateMode(string value) => new CreateMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CreateMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CreateMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
