// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(CopyActivityConverter))]
    public partial class CopyActivity : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsCollectionDefined(Inputs))
            {
                writer.WritePropertyName("inputs"u8);
                writer.WriteStartArray();
                foreach (var item in Inputs)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Outputs))
            {
                writer.WritePropertyName("outputs"u8);
                writer.WriteStartArray();
                foreach (var item in Outputs)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(LinkedServiceName))
            {
                writer.WritePropertyName("linkedServiceName"u8);
                writer.WriteObjectValue(LinkedServiceName);
            }
            if (Optional.IsDefined(Policy))
            {
                writer.WritePropertyName("policy"u8);
                writer.WriteObjectValue(Policy);
            }
            writer.WritePropertyName("name"u8);
            writer.WriteStringValue(Name);
            writer.WritePropertyName("type"u8);
            writer.WriteStringValue(Type);
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(OnInactiveMarkAs))
            {
                writer.WritePropertyName("onInactiveMarkAs"u8);
                writer.WriteStringValue(OnInactiveMarkAs.Value.ToString());
            }
            if (Optional.IsCollectionDefined(DependsOn))
            {
                writer.WritePropertyName("dependsOn"u8);
                writer.WriteStartArray();
                foreach (var item in DependsOn)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(UserProperties))
            {
                writer.WritePropertyName("userProperties"u8);
                writer.WriteStartArray();
                foreach (var item in UserProperties)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("typeProperties"u8);
            writer.WriteStartObject();
            writer.WritePropertyName("source"u8);
            writer.WriteObjectValue(Source);
            writer.WritePropertyName("sink"u8);
            writer.WriteObjectValue(Sink);
            if (Optional.IsDefined(Translator))
            {
                writer.WritePropertyName("translator"u8);
                writer.WriteObjectValue<object>(Translator);
            }
            if (Optional.IsDefined(EnableStaging))
            {
                writer.WritePropertyName("enableStaging"u8);
                writer.WriteObjectValue<object>(EnableStaging);
            }
            if (Optional.IsDefined(StagingSettings))
            {
                writer.WritePropertyName("stagingSettings"u8);
                writer.WriteObjectValue(StagingSettings);
            }
            if (Optional.IsDefined(ParallelCopies))
            {
                writer.WritePropertyName("parallelCopies"u8);
                writer.WriteObjectValue<object>(ParallelCopies);
            }
            if (Optional.IsDefined(DataIntegrationUnits))
            {
                writer.WritePropertyName("dataIntegrationUnits"u8);
                writer.WriteObjectValue<object>(DataIntegrationUnits);
            }
            if (Optional.IsDefined(EnableSkipIncompatibleRow))
            {
                writer.WritePropertyName("enableSkipIncompatibleRow"u8);
                writer.WriteObjectValue<object>(EnableSkipIncompatibleRow);
            }
            if (Optional.IsDefined(RedirectIncompatibleRowSettings))
            {
                writer.WritePropertyName("redirectIncompatibleRowSettings"u8);
                writer.WriteObjectValue(RedirectIncompatibleRowSettings);
            }
            if (Optional.IsDefined(LogStorageSettings))
            {
                writer.WritePropertyName("logStorageSettings"u8);
                writer.WriteObjectValue(LogStorageSettings);
            }
            if (Optional.IsDefined(LogSettings))
            {
                writer.WritePropertyName("logSettings"u8);
                writer.WriteObjectValue(LogSettings);
            }
            if (Optional.IsCollectionDefined(PreserveRules))
            {
                writer.WritePropertyName("preserveRules"u8);
                writer.WriteStartArray();
                foreach (var item in PreserveRules)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteObjectValue<object>(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Preserve))
            {
                writer.WritePropertyName("preserve"u8);
                writer.WriteStartArray();
                foreach (var item in Preserve)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteObjectValue<object>(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ValidateDataConsistency))
            {
                writer.WritePropertyName("validateDataConsistency"u8);
                writer.WriteObjectValue<object>(ValidateDataConsistency);
            }
            if (Optional.IsDefined(SkipErrorFile))
            {
                writer.WritePropertyName("skipErrorFile"u8);
                writer.WriteObjectValue(SkipErrorFile);
            }
            writer.WriteEndObject();
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static CopyActivity DeserializeCopyActivity(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<DatasetReference> inputs = default;
            IList<DatasetReference> outputs = default;
            LinkedServiceReference linkedServiceName = default;
            ActivityPolicy policy = default;
            string name = default;
            string type = default;
            string description = default;
            ActivityState? state = default;
            ActivityOnInactiveMarkAs? onInactiveMarkAs = default;
            IList<ActivityDependency> dependsOn = default;
            IList<UserProperty> userProperties = default;
            CopySource source = default;
            CopySink sink = default;
            object translator = default;
            object enableStaging = default;
            StagingSettings stagingSettings = default;
            object parallelCopies = default;
            object dataIntegrationUnits = default;
            object enableSkipIncompatibleRow = default;
            RedirectIncompatibleRowSettings redirectIncompatibleRowSettings = default;
            LogStorageSettings logStorageSettings = default;
            LogSettings logSettings = default;
            IList<object> preserveRules = default;
            IList<object> preserve = default;
            object validateDataConsistency = default;
            SkipErrorFile skipErrorFile = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("inputs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DatasetReference> array = new List<DatasetReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DatasetReference.DeserializeDatasetReference(item));
                    }
                    inputs = array;
                    continue;
                }
                if (property.NameEquals("outputs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DatasetReference> array = new List<DatasetReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DatasetReference.DeserializeDatasetReference(item));
                    }
                    outputs = array;
                    continue;
                }
                if (property.NameEquals("linkedServiceName"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    linkedServiceName = LinkedServiceReference.DeserializeLinkedServiceReference(property.Value);
                    continue;
                }
                if (property.NameEquals("policy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    policy = ActivityPolicy.DeserializeActivityPolicy(property.Value);
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new ActivityState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("onInactiveMarkAs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onInactiveMarkAs = new ActivityOnInactiveMarkAs(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dependsOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ActivityDependency> array = new List<ActivityDependency>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ActivityDependency.DeserializeActivityDependency(item));
                    }
                    dependsOn = array;
                    continue;
                }
                if (property.NameEquals("userProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<UserProperty> array = new List<UserProperty>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(UserProperty.DeserializeUserProperty(item));
                    }
                    userProperties = array;
                    continue;
                }
                if (property.NameEquals("typeProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("source"u8))
                        {
                            source = CopySource.DeserializeCopySource(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("sink"u8))
                        {
                            sink = CopySink.DeserializeCopySink(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("translator"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            translator = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("enableStaging"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableStaging = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("stagingSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            stagingSettings = StagingSettings.DeserializeStagingSettings(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("parallelCopies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            parallelCopies = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("dataIntegrationUnits"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dataIntegrationUnits = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("enableSkipIncompatibleRow"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableSkipIncompatibleRow = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("redirectIncompatibleRowSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            redirectIncompatibleRowSettings = RedirectIncompatibleRowSettings.DeserializeRedirectIncompatibleRowSettings(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("logStorageSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            logStorageSettings = LogStorageSettings.DeserializeLogStorageSettings(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("logSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            logSettings = LogSettings.DeserializeLogSettings(property0.Value);
                            continue;
                        }
                        if (property0.NameEquals("preserveRules"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<object> array = new List<object>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                if (item.ValueKind == JsonValueKind.Null)
                                {
                                    array.Add(null);
                                }
                                else
                                {
                                    array.Add(item.GetObject());
                                }
                            }
                            preserveRules = array;
                            continue;
                        }
                        if (property0.NameEquals("preserve"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<object> array = new List<object>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                if (item.ValueKind == JsonValueKind.Null)
                                {
                                    array.Add(null);
                                }
                                else
                                {
                                    array.Add(item.GetObject());
                                }
                            }
                            preserve = array;
                            continue;
                        }
                        if (property0.NameEquals("validateDataConsistency"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            validateDataConsistency = property0.Value.GetObject();
                            continue;
                        }
                        if (property0.NameEquals("skipErrorFile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            skipErrorFile = SkipErrorFile.DeserializeSkipErrorFile(property0.Value);
                            continue;
                        }
                    }
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new CopyActivity(
                name,
                type,
                description,
                state,
                onInactiveMarkAs,
                dependsOn ?? new ChangeTrackingList<ActivityDependency>(),
                userProperties ?? new ChangeTrackingList<UserProperty>(),
                additionalProperties,
                linkedServiceName,
                policy,
                inputs ?? new ChangeTrackingList<DatasetReference>(),
                outputs ?? new ChangeTrackingList<DatasetReference>(),
                source,
                sink,
                translator,
                enableStaging,
                stagingSettings,
                parallelCopies,
                dataIntegrationUnits,
                enableSkipIncompatibleRow,
                redirectIncompatibleRowSettings,
                logStorageSettings,
                logSettings,
                preserveRules ?? new ChangeTrackingList<object>(),
                preserve ?? new ChangeTrackingList<object>(),
                validateDataConsistency,
                skipErrorFile);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new CopyActivity FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCopyActivity(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class CopyActivityConverter : JsonConverter<CopyActivity>
        {
            public override void Write(Utf8JsonWriter writer, CopyActivity model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override CopyActivity Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeCopyActivity(document.RootElement);
            }
        }
    }
}
