// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The type of the spark config. </summary>
    public readonly partial struct ConfigurationType : IEquatable<ConfigurationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConfigurationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConfigurationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string CustomizedValue = "Customized";
        private const string ArtifactValue = "Artifact";

        /// <summary> Default. </summary>
        public static ConfigurationType Default { get; } = new ConfigurationType(DefaultValue);
        /// <summary> Customized. </summary>
        public static ConfigurationType Customized { get; } = new ConfigurationType(CustomizedValue);
        /// <summary> Artifact. </summary>
        public static ConfigurationType Artifact { get; } = new ConfigurationType(ArtifactValue);
        /// <summary> Determines if two <see cref="ConfigurationType"/> values are the same. </summary>
        public static bool operator ==(ConfigurationType left, ConfigurationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConfigurationType"/> values are not the same. </summary>
        public static bool operator !=(ConfigurationType left, ConfigurationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConfigurationType"/>. </summary>
        public static implicit operator ConfigurationType(string value) => new ConfigurationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConfigurationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConfigurationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
