// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A copy activity Azure Blob sink. </summary>
    public partial class BlobSink : CopySink
    {
        /// <summary> Initializes a new instance of <see cref="BlobSink"/>. </summary>
        public BlobSink()
        {
            Type = "BlobSink";
        }

        /// <summary> Initializes a new instance of <see cref="BlobSink"/>. </summary>
        /// <param name="type"> Copy sink type. </param>
        /// <param name="writeBatchSize"> Write batch size. Type: integer (or Expression with resultType integer), minimum: 0. </param>
        /// <param name="writeBatchTimeout"> Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="sinkRetryCount"> Sink retry count. Type: integer (or Expression with resultType integer). </param>
        /// <param name="sinkRetryWait"> Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="blobWriterOverwriteFiles"> Blob writer overwrite files. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="blobWriterDateTimeFormat"> Blob writer date time format. Type: string (or Expression with resultType string). </param>
        /// <param name="blobWriterAddHeader"> Blob writer add header. Type: boolean (or Expression with resultType boolean). </param>
        /// <param name="copyBehavior"> The type of copy behavior for copy sink. </param>
        internal BlobSink(string type, object writeBatchSize, object writeBatchTimeout, object sinkRetryCount, object sinkRetryWait, object maxConcurrentConnections, IDictionary<string, object> additionalProperties, object blobWriterOverwriteFiles, object blobWriterDateTimeFormat, object blobWriterAddHeader, object copyBehavior) : base(type, writeBatchSize, writeBatchTimeout, sinkRetryCount, sinkRetryWait, maxConcurrentConnections, additionalProperties)
        {
            BlobWriterOverwriteFiles = blobWriterOverwriteFiles;
            BlobWriterDateTimeFormat = blobWriterDateTimeFormat;
            BlobWriterAddHeader = blobWriterAddHeader;
            CopyBehavior = copyBehavior;
            Type = type ?? "BlobSink";
        }

        /// <summary> Blob writer overwrite files. Type: boolean (or Expression with resultType boolean). </summary>
        public object BlobWriterOverwriteFiles { get; set; }
        /// <summary> Blob writer date time format. Type: string (or Expression with resultType string). </summary>
        public object BlobWriterDateTimeFormat { get; set; }
        /// <summary> Blob writer add header. Type: boolean (or Expression with resultType boolean). </summary>
        public object BlobWriterAddHeader { get; set; }
        /// <summary> The type of copy behavior for copy sink. </summary>
        public object CopyBehavior { get; set; }
    }
}
