// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The type used for authentication. Type: string. </summary>
    public readonly partial struct AzureStorageAuthenticationType : IEquatable<AzureStorageAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureStorageAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureStorageAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnonymousValue = "Anonymous";
        private const string AccountKeyValue = "AccountKey";
        private const string SasUriValue = "SasUri";
        private const string ServicePrincipalValue = "ServicePrincipal";
        private const string MsiValue = "Msi";

        /// <summary> Anonymous. </summary>
        public static AzureStorageAuthenticationType Anonymous { get; } = new AzureStorageAuthenticationType(AnonymousValue);
        /// <summary> AccountKey. </summary>
        public static AzureStorageAuthenticationType AccountKey { get; } = new AzureStorageAuthenticationType(AccountKeyValue);
        /// <summary> SasUri. </summary>
        public static AzureStorageAuthenticationType SasUri { get; } = new AzureStorageAuthenticationType(SasUriValue);
        /// <summary> ServicePrincipal. </summary>
        public static AzureStorageAuthenticationType ServicePrincipal { get; } = new AzureStorageAuthenticationType(ServicePrincipalValue);
        /// <summary> Msi. </summary>
        public static AzureStorageAuthenticationType Msi { get; } = new AzureStorageAuthenticationType(MsiValue);
        /// <summary> Determines if two <see cref="AzureStorageAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(AzureStorageAuthenticationType left, AzureStorageAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureStorageAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(AzureStorageAuthenticationType left, AzureStorageAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureStorageAuthenticationType"/>. </summary>
        public static implicit operator AzureStorageAuthenticationType(string value) => new AzureStorageAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureStorageAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureStorageAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
