// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Azure ML WebService Input/Output file. </summary>
    public partial class AzureMLWebServiceFile
    {
        /// <summary> Initializes a new instance of <see cref="AzureMLWebServiceFile"/>. </summary>
        /// <param name="filePath"> The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string). </param>
        /// <param name="linkedServiceName"> Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="filePath"/> or <paramref name="linkedServiceName"/> is null. </exception>
        public AzureMLWebServiceFile(object filePath, LinkedServiceReference linkedServiceName)
        {
            Argument.AssertNotNull(filePath, nameof(filePath));
            Argument.AssertNotNull(linkedServiceName, nameof(linkedServiceName));

            FilePath = filePath;
            LinkedServiceName = linkedServiceName;
        }

        /// <summary> The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type: string (or Expression with resultType string). </summary>
        public object FilePath { get; set; }
        /// <summary> Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located. </summary>
        public LinkedServiceReference LinkedServiceName { get; set; }
    }
}
