// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(AzureMLWebServiceFileConverter))]
    public partial class AzureMLWebServiceFile : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("filePath"u8);
            writer.WriteObjectValue<object>(FilePath);
            writer.WritePropertyName("linkedServiceName"u8);
            writer.WriteObjectValue(LinkedServiceName);
            writer.WriteEndObject();
        }

        internal static AzureMLWebServiceFile DeserializeAzureMLWebServiceFile(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            object filePath = default;
            LinkedServiceReference linkedServiceName = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("filePath"u8))
                {
                    filePath = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("linkedServiceName"u8))
                {
                    linkedServiceName = LinkedServiceReference.DeserializeLinkedServiceReference(property.Value);
                    continue;
                }
            }
            return new AzureMLWebServiceFile(filePath, linkedServiceName);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AzureMLWebServiceFile FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAzureMLWebServiceFile(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class AzureMLWebServiceFileConverter : JsonConverter<AzureMLWebServiceFile>
        {
            public override void Write(Utf8JsonWriter writer, AzureMLWebServiceFile model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override AzureMLWebServiceFile Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAzureMLWebServiceFile(document.RootElement);
            }
        }
    }
}
