// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> A copy activity Azure Databricks Delta Lake source. </summary>
    public partial class AzureDatabricksDeltaLakeSource : CopySource
    {
        /// <summary> Initializes a new instance of <see cref="AzureDatabricksDeltaLakeSource"/>. </summary>
        public AzureDatabricksDeltaLakeSource()
        {
            Type = "AzureDatabricksDeltaLakeSource";
        }

        /// <summary> Initializes a new instance of <see cref="AzureDatabricksDeltaLakeSource"/>. </summary>
        /// <param name="type"> Copy source type. </param>
        /// <param name="sourceRetryCount"> Source retry count. Type: integer (or Expression with resultType integer). </param>
        /// <param name="sourceRetryWait"> Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="maxConcurrentConnections"> The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="query"> Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string). </param>
        /// <param name="exportSettings"> Azure Databricks Delta Lake export settings. </param>
        internal AzureDatabricksDeltaLakeSource(string type, object sourceRetryCount, object sourceRetryWait, object maxConcurrentConnections, IDictionary<string, object> additionalProperties, object query, AzureDatabricksDeltaLakeExportCommand exportSettings) : base(type, sourceRetryCount, sourceRetryWait, maxConcurrentConnections, additionalProperties)
        {
            Query = query;
            ExportSettings = exportSettings;
            Type = type ?? "AzureDatabricksDeltaLakeSource";
        }

        /// <summary> Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string). </summary>
        public object Query { get; set; }
        /// <summary> Azure Databricks Delta Lake export settings. </summary>
        public AzureDatabricksDeltaLakeExportCommand ExportSettings { get; set; }
    }
}
