// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Azure Databricks Delta Lake import command settings. </summary>
    public partial class AzureDatabricksDeltaLakeImportCommand : ImportSettings
    {
        /// <summary> Initializes a new instance of <see cref="AzureDatabricksDeltaLakeImportCommand"/>. </summary>
        public AzureDatabricksDeltaLakeImportCommand()
        {
            Type = "AzureDatabricksDeltaLakeImportCommand";
        }

        /// <summary> Initializes a new instance of <see cref="AzureDatabricksDeltaLakeImportCommand"/>. </summary>
        /// <param name="type"> The import setting type. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="dateFormat"> Specify the date format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </param>
        /// <param name="timestampFormat"> Specify the timestamp format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </param>
        internal AzureDatabricksDeltaLakeImportCommand(string type, IDictionary<string, object> additionalProperties, object dateFormat, object timestampFormat) : base(type, additionalProperties)
        {
            DateFormat = dateFormat;
            TimestampFormat = timestampFormat;
            Type = type ?? "AzureDatabricksDeltaLakeImportCommand";
        }

        /// <summary> Specify the date format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </summary>
        public object DateFormat { get; set; }
        /// <summary> Specify the timestamp format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string). </summary>
        public object TimestampFormat { get; set; }
    }
}
