// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> The location of amazon S3 dataset. </summary>
    public partial class AmazonS3Location : DatasetLocation
    {
        /// <summary> Initializes a new instance of <see cref="AmazonS3Location"/>. </summary>
        public AmazonS3Location()
        {
            Type = "AmazonS3Location";
        }

        /// <summary> Initializes a new instance of <see cref="AmazonS3Location"/>. </summary>
        /// <param name="type"> Type of dataset storage location. </param>
        /// <param name="folderPath"> Specify the folder path of dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="fileName"> Specify the file name of dataset. Type: string (or Expression with resultType string). </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="bucketName"> Specify the bucketName of amazon S3. Type: string (or Expression with resultType string). </param>
        /// <param name="version"> Specify the version of amazon S3. Type: string (or Expression with resultType string). </param>
        internal AmazonS3Location(string type, object folderPath, object fileName, IDictionary<string, object> additionalProperties, object bucketName, object version) : base(type, folderPath, fileName, additionalProperties)
        {
            BucketName = bucketName;
            Version = version;
            Type = type ?? "AmazonS3Location";
        }

        /// <summary> Specify the bucketName of amazon S3. Type: string (or Expression with resultType string). </summary>
        public object BucketName { get; set; }
        /// <summary> Specify the version of amazon S3. Type: string (or Expression with resultType string). </summary>
        public object Version { get; set; }
    }
}
