// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Activity state. This is an optional property and if not provided, the state will be Active by default. </summary>
    public readonly partial struct ActivityState : IEquatable<ActivityState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ActivityState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ActivityState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string InactiveValue = "Inactive";

        /// <summary> Active. </summary>
        public static ActivityState Active { get; } = new ActivityState(ActiveValue);
        /// <summary> Inactive. </summary>
        public static ActivityState Inactive { get; } = new ActivityState(InactiveValue);
        /// <summary> Determines if two <see cref="ActivityState"/> values are the same. </summary>
        public static bool operator ==(ActivityState left, ActivityState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ActivityState"/> values are not the same. </summary>
        public static bool operator !=(ActivityState left, ActivityState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ActivityState"/>. </summary>
        public static implicit operator ActivityState(string value) => new ActivityState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ActivityState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ActivityState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
