// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Information about an activity run in a pipeline. </summary>
    public partial class ActivityRun
    {
        /// <summary> Initializes a new instance of <see cref="ActivityRun"/>. </summary>
        internal ActivityRun()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="ActivityRun"/>. </summary>
        /// <param name="pipelineName"> The name of the pipeline. </param>
        /// <param name="pipelineRunId"> The id of the pipeline run. </param>
        /// <param name="activityName"> The name of the activity. </param>
        /// <param name="activityType"> The type of the activity. </param>
        /// <param name="activityRunId"> The id of the activity run. </param>
        /// <param name="linkedServiceName"> The name of the compute linked service. </param>
        /// <param name="status"> The status of the activity run. </param>
        /// <param name="activityRunStart"> The start time of the activity run in 'ISO 8601' format. </param>
        /// <param name="activityRunEnd"> The end time of the activity run in 'ISO 8601' format. </param>
        /// <param name="durationInMs"> The duration of the activity run. </param>
        /// <param name="input"> The input for the activity. </param>
        /// <param name="output"> The output for the activity. </param>
        /// <param name="error"> The error if any from the activity run. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal ActivityRun(string pipelineName, string pipelineRunId, string activityName, string activityType, string activityRunId, string linkedServiceName, string status, DateTimeOffset? activityRunStart, DateTimeOffset? activityRunEnd, int? durationInMs, object input, object output, object error, IReadOnlyDictionary<string, object> additionalProperties)
        {
            PipelineName = pipelineName;
            PipelineRunId = pipelineRunId;
            ActivityName = activityName;
            ActivityType = activityType;
            ActivityRunId = activityRunId;
            LinkedServiceName = linkedServiceName;
            Status = status;
            ActivityRunStart = activityRunStart;
            ActivityRunEnd = activityRunEnd;
            DurationInMs = durationInMs;
            Input = input;
            Output = output;
            Error = error;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> The name of the pipeline. </summary>
        public string PipelineName { get; }
        /// <summary> The id of the pipeline run. </summary>
        public string PipelineRunId { get; }
        /// <summary> The name of the activity. </summary>
        public string ActivityName { get; }
        /// <summary> The type of the activity. </summary>
        public string ActivityType { get; }
        /// <summary> The id of the activity run. </summary>
        public string ActivityRunId { get; }
        /// <summary> The name of the compute linked service. </summary>
        public string LinkedServiceName { get; }
        /// <summary> The status of the activity run. </summary>
        public string Status { get; }
        /// <summary> The start time of the activity run in 'ISO 8601' format. </summary>
        public DateTimeOffset? ActivityRunStart { get; }
        /// <summary> The end time of the activity run in 'ISO 8601' format. </summary>
        public DateTimeOffset? ActivityRunEnd { get; }
        /// <summary> The duration of the activity run. </summary>
        public int? DurationInMs { get; }
        /// <summary> The input for the activity. </summary>
        public object Input { get; }
        /// <summary> The output for the activity. </summary>
        public object Output { get; }
        /// <summary> The error if any from the activity run. </summary>
        public object Error { get; }
        /// <summary> Additional Properties. </summary>
        public IReadOnlyDictionary<string, object> AdditionalProperties { get; }
    }
}
