// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    /// <summary> Execution policy for an activity. </summary>
    public partial class ActivityPolicy
    {
        /// <summary> Initializes a new instance of <see cref="ActivityPolicy"/>. </summary>
        public ActivityPolicy()
        {
            AdditionalProperties = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="ActivityPolicy"/>. </summary>
        /// <param name="timeout"> Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </param>
        /// <param name="retry"> Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0. </param>
        /// <param name="retryIntervalInSeconds"> Interval between each retry attempt (in seconds). The default is 30 sec. </param>
        /// <param name="secureInput"> When set to true, Input from activity is considered as secure and will not be logged to monitoring. </param>
        /// <param name="secureOutput"> When set to true, Output from activity is considered as secure and will not be logged to monitoring. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal ActivityPolicy(object timeout, object retry, int? retryIntervalInSeconds, bool? secureInput, bool? secureOutput, IDictionary<string, object> additionalProperties)
        {
            Timeout = timeout;
            Retry = retry;
            RetryIntervalInSeconds = retryIntervalInSeconds;
            SecureInput = secureInput;
            SecureOutput = secureOutput;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])). </summary>
        public object Timeout { get; set; }
        /// <summary> Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0. </summary>
        public object Retry { get; set; }
        /// <summary> Interval between each retry attempt (in seconds). The default is 30 sec. </summary>
        public int? RetryIntervalInSeconds { get; set; }
        /// <summary> When set to true, Input from activity is considered as secure and will not be logged to monitoring. </summary>
        public bool? SecureInput { get; set; }
        /// <summary> When set to true, Output from activity is considered as secure and will not be logged to monitoring. </summary>
        public bool? SecureOutput { get; set; }
        /// <summary> Additional Properties. </summary>
        public IDictionary<string, object> AdditionalProperties { get; }
    }
}
