// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Text.Json.Serialization;
using Azure.Core;

namespace Azure.Analytics.Synapse.Artifacts.Models
{
    [JsonConverter(typeof(ActivityPolicyConverter))]
    public partial class ActivityPolicy : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(Timeout))
            {
                writer.WritePropertyName("timeout"u8);
                writer.WriteObjectValue<object>(Timeout);
            }
            if (Optional.IsDefined(Retry))
            {
                writer.WritePropertyName("retry"u8);
                writer.WriteObjectValue<object>(Retry);
            }
            if (Optional.IsDefined(RetryIntervalInSeconds))
            {
                writer.WritePropertyName("retryIntervalInSeconds"u8);
                writer.WriteNumberValue(RetryIntervalInSeconds.Value);
            }
            if (Optional.IsDefined(SecureInput))
            {
                writer.WritePropertyName("secureInput"u8);
                writer.WriteBooleanValue(SecureInput.Value);
            }
            if (Optional.IsDefined(SecureOutput))
            {
                writer.WritePropertyName("secureOutput"u8);
                writer.WriteBooleanValue(SecureOutput.Value);
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
        }

        internal static ActivityPolicy DeserializeActivityPolicy(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            object timeout = default;
            object retry = default;
            int? retryIntervalInSeconds = default;
            bool? secureInput = default;
            bool? secureOutput = default;
            IDictionary<string, object> additionalProperties = default;
            Dictionary<string, object> additionalPropertiesDictionary = new Dictionary<string, object>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("timeout"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    timeout = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("retry"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    retry = property.Value.GetObject();
                    continue;
                }
                if (property.NameEquals("retryIntervalInSeconds"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    retryIntervalInSeconds = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("secureInput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secureInput = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("secureOutput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    secureOutput = property.Value.GetBoolean();
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, property.Value.GetObject());
            }
            additionalProperties = additionalPropertiesDictionary;
            return new ActivityPolicy(
                timeout,
                retry,
                retryIntervalInSeconds,
                secureInput,
                secureOutput,
                additionalProperties);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ActivityPolicy FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeActivityPolicy(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }

        internal partial class ActivityPolicyConverter : JsonConverter<ActivityPolicy>
        {
            public override void Write(Utf8JsonWriter writer, ActivityPolicy model, JsonSerializerOptions options)
            {
                writer.WriteObjectValue(model);
            }

            public override ActivityPolicy Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeActivityPolicy(document.RootElement);
            }
        }
    }
}
