// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Analytics.Synapse.Artifacts.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Synapse.Artifacts
{
    internal partial class LinkConnectionRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of LinkConnectionRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example `https://myworkspace.dev.azuresynapse.net`. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="endpoint"/> is null. </exception>
        public LinkConnectionRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint)
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
        }

        internal HttpMessage CreateListByWorkspaceRequest()
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List link connections. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<LinkConnectionListResponse>> ListByWorkspaceAsync(CancellationToken cancellationToken = default)
        {
            using var message = CreateListByWorkspaceRequest();
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionListResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LinkConnectionListResponse.DeserializeLinkConnectionListResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List link connections. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<LinkConnectionListResponse> ListByWorkspace(CancellationToken cancellationToken = default)
        {
            using var message = CreateListByWorkspaceRequest();
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionListResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LinkConnectionListResponse.DeserializeLinkConnectionListResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string linkConnectionName, LinkConnectionResource linkConnection)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(linkConnection);
            request.Content = content;
            return message;
        }

        /// <summary> Creates or updates a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="linkConnection"> Link connection resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="linkConnection"/> is null. </exception>
        public async Task<Response<LinkConnectionResource>> CreateOrUpdateAsync(string linkConnectionName, LinkConnectionResource linkConnection, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (linkConnection == null)
            {
                throw new ArgumentNullException(nameof(linkConnection));
            }

            using var message = CreateCreateOrUpdateRequest(linkConnectionName, linkConnection);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionResource value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LinkConnectionResource.DeserializeLinkConnectionResource(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates or updates a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="linkConnection"> Link connection resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="linkConnection"/> is null. </exception>
        public Response<LinkConnectionResource> CreateOrUpdate(string linkConnectionName, LinkConnectionResource linkConnection, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (linkConnection == null)
            {
                throw new ArgumentNullException(nameof(linkConnection));
            }

            using var message = CreateCreateOrUpdateRequest(linkConnectionName, linkConnection);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionResource value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LinkConnectionResource.DeserializeLinkConnectionResource(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response<LinkConnectionResource>> GetAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateGetRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionResource value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LinkConnectionResource.DeserializeLinkConnectionResource(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response<LinkConnectionResource> Get(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateGetRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionResource value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LinkConnectionResource.DeserializeLinkConnectionResource(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response> DeleteAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateDeleteRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response Delete(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateDeleteRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateEditTablesRequest(string linkConnectionName, EditTablesRequest editTablesRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/edittables", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(editTablesRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Edit tables for a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="editTablesRequest"> Edit tables request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="editTablesRequest"/> is null. </exception>
        public async Task<Response> EditTablesAsync(string linkConnectionName, EditTablesRequest editTablesRequest, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (editTablesRequest == null)
            {
                throw new ArgumentNullException(nameof(editTablesRequest));
            }

            using var message = CreateEditTablesRequest(linkConnectionName, editTablesRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Edit tables for a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="editTablesRequest"> Edit tables request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="editTablesRequest"/> is null. </exception>
        public Response EditTables(string linkConnectionName, EditTablesRequest editTablesRequest, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (editTablesRequest == null)
            {
                throw new ArgumentNullException(nameof(editTablesRequest));
            }

            using var message = CreateEditTablesRequest(linkConnectionName, editTablesRequest);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStartRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/start", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Start a link connection. It may take a few minutes from Starting to Running, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response> StartAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateStartRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Start a link connection. It may take a few minutes from Starting to Running, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response Start(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateStartRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStopRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/stop", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Stop a link connection. It may take a few minutes from Stopping to stopped, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response> StopAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateStopRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Stop a link connection. It may take a few minutes from Stopping to stopped, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response Stop(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateStopRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetDetailedStatusRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/detailedstatus", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get the detailed status of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response<LinkConnectionDetailedStatus>> GetDetailedStatusAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateGetDetailedStatusRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionDetailedStatus value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LinkConnectionDetailedStatus.DeserializeLinkConnectionDetailedStatus(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get the detailed status of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response<LinkConnectionDetailedStatus> GetDetailedStatus(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateGetDetailedStatusRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionDetailedStatus value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LinkConnectionDetailedStatus.DeserializeLinkConnectionDetailedStatus(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListLinkTablesRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/linktables", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List the link tables of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response<LinkTableListResponse>> ListLinkTablesAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateListLinkTablesRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkTableListResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LinkTableListResponse.DeserializeLinkTableListResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List the link tables of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response<LinkTableListResponse> ListLinkTables(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateListLinkTablesRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkTableListResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LinkTableListResponse.DeserializeLinkTableListResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateQueryTableStatusRequest(string linkConnectionName, QueryTableStatusRequest queryTableStatusRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/querytablestatus", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(queryTableStatusRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Query the link table status of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="queryTableStatusRequest"> Query table status request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="queryTableStatusRequest"/> is null. </exception>
        public async Task<Response<LinkConnectionQueryTableStatus>> QueryTableStatusAsync(string linkConnectionName, QueryTableStatusRequest queryTableStatusRequest, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (queryTableStatusRequest == null)
            {
                throw new ArgumentNullException(nameof(queryTableStatusRequest));
            }

            using var message = CreateQueryTableStatusRequest(linkConnectionName, queryTableStatusRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionQueryTableStatus value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LinkConnectionQueryTableStatus.DeserializeLinkConnectionQueryTableStatus(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Query the link table status of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="queryTableStatusRequest"> Query table status request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="queryTableStatusRequest"/> is null. </exception>
        public Response<LinkConnectionQueryTableStatus> QueryTableStatus(string linkConnectionName, QueryTableStatusRequest queryTableStatusRequest, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (queryTableStatusRequest == null)
            {
                throw new ArgumentNullException(nameof(queryTableStatusRequest));
            }

            using var message = CreateQueryTableStatusRequest(linkConnectionName, queryTableStatusRequest);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionQueryTableStatus value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LinkConnectionQueryTableStatus.DeserializeLinkConnectionQueryTableStatus(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateLandingZoneCredentialRequest(string linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/updateLandingZoneCredential", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(updateLandingZoneCredentialRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Update landing zone credential of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="updateLandingZoneCredentialRequest"> update landing zone credential request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="updateLandingZoneCredentialRequest"/> is null. </exception>
        public async Task<Response> UpdateLandingZoneCredentialAsync(string linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (updateLandingZoneCredentialRequest == null)
            {
                throw new ArgumentNullException(nameof(updateLandingZoneCredentialRequest));
            }

            using var message = CreateUpdateLandingZoneCredentialRequest(linkConnectionName, updateLandingZoneCredentialRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update landing zone credential of a link connection. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="updateLandingZoneCredentialRequest"> update landing zone credential request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> or <paramref name="updateLandingZoneCredentialRequest"/> is null. </exception>
        public Response UpdateLandingZoneCredential(string linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }
            if (updateLandingZoneCredentialRequest == null)
            {
                throw new ArgumentNullException(nameof(updateLandingZoneCredentialRequest));
            }

            using var message = CreateUpdateLandingZoneCredentialRequest(linkConnectionName, updateLandingZoneCredentialRequest);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreatePauseRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/pause", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Pause a link connection. It may take a few minutes from Pausing to Paused, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response> PauseAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreatePauseRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Pause a link connection. It may take a few minutes from Pausing to Paused, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response Pause(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreatePauseRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateResumeRequest(string linkConnectionName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/linkconnections/", false);
            uri.AppendPath(linkConnectionName, true);
            uri.AppendPath("/resume", false);
            uri.AppendQuery("api-version", "2023-04-18-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Resume a link connection. It may take a few minutes from Resuming to Running, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public async Task<Response> ResumeAsync(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateResumeRequest(linkConnectionName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Resume a link connection. It may take a few minutes from Resuming to Running, monitor the status with LinkConnection_GetDetailedStatus. </summary>
        /// <param name="linkConnectionName"> The link connection name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="linkConnectionName"/> is null. </exception>
        public Response Resume(string linkConnectionName, CancellationToken cancellationToken = default)
        {
            if (linkConnectionName == null)
            {
                throw new ArgumentNullException(nameof(linkConnectionName));
            }

            using var message = CreateResumeRequest(linkConnectionName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListByWorkspaceNextPageRequest(string nextLink)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> List link connections. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<LinkConnectionListResponse>> ListByWorkspaceNextPageAsync(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListByWorkspaceNextPageRequest(nextLink);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionListResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = LinkConnectionListResponse.DeserializeLinkConnectionListResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List link connections. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<LinkConnectionListResponse> ListByWorkspaceNextPage(string nextLink, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListByWorkspaceNextPageRequest(nextLink);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        LinkConnectionListResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = LinkConnectionListResponse.DeserializeLinkConnectionListResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
