// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.IO;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Analytics.Synapse.Artifacts.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Synapse.Artifacts
{
    /// <summary> The Library service client. </summary>
    public partial class LibraryClient
    {
        private readonly ClientDiagnostics _clientDiagnostics;
        private readonly HttpPipeline _pipeline;
        internal LibraryRestClient RestClient { get; }

        /// <summary> Initializes a new instance of LibraryClient for mocking. </summary>
        protected LibraryClient()
        {
        }

        /// <summary> Initializes a new instance of LibraryClient. </summary>
        /// <param name="endpoint"> The workspace development endpoint, for example `https://myworkspace.dev.azuresynapse.net`. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        public LibraryClient(Uri endpoint, TokenCredential credential, ArtifactsClientOptions options = null)
        {
            if (endpoint == null)
            {
                throw new ArgumentNullException(nameof(endpoint));
            }
            if (credential == null)
            {
                throw new ArgumentNullException(nameof(credential));
            }

            options ??= new ArtifactsClientOptions();
            _clientDiagnostics = new ClientDiagnostics(options);
            string[] scopes = { "https://dev.azuresynapse.net/.default" };
            _pipeline = HttpPipelineBuilder.Build(options, new BearerTokenAuthenticationPolicy(credential, scopes));
            RestClient = new LibraryRestClient(_clientDiagnostics, _pipeline, endpoint);
        }

        /// <summary> Initializes a new instance of LibraryClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example `https://myworkspace.dev.azuresynapse.net`. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="endpoint"/> is null. </exception>
        internal LibraryClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint)
        {
            RestClient = new LibraryRestClient(clientDiagnostics, pipeline, endpoint);
            _clientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
        }

        /// <summary> Get Operation result for Library. </summary>
        /// <param name="operationId"> operation id for which status is requested. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<object>> GetOperationResultAsync(string operationId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("LibraryClient.GetOperationResult");
            scope.Start();
            try
            {
                return await RestClient.GetOperationResultAsync(operationId, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get Operation result for Library. </summary>
        /// <param name="operationId"> operation id for which status is requested. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<object> GetOperationResult(string operationId, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("LibraryClient.GetOperationResult");
            scope.Start();
            try
            {
                return RestClient.GetOperationResult(operationId, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get Library. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<LibraryResource>> GetAsync(string libraryName, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("LibraryClient.Get");
            scope.Start();
            try
            {
                return await RestClient.GetAsync(libraryName, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Get Library. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<LibraryResource> Get(string libraryName, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("LibraryClient.Get");
            scope.Start();
            try
            {
                return RestClient.Get(libraryName, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Append the content to the library resource created using the create operation. The maximum content size is 4MiB. Content larger than 4MiB must be appended in 4MiB chunks. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="content"> Library file chunk. </param>
        /// <param name="blobConditionAppendPosition"> Set this header to a byte offset at which the block is expected to be appended. The request succeeds only if the current offset matches this value. Otherwise, the request fails with the AppendPositionConditionNotMet error (HTTP status code 412 – Precondition Failed). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> AppendAsync(string libraryName, Stream content, long? blobConditionAppendPosition = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("LibraryClient.Append");
            scope.Start();
            try
            {
                return await RestClient.AppendAsync(libraryName, content, blobConditionAppendPosition, cancellationToken).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Append the content to the library resource created using the create operation. The maximum content size is 4MiB. Content larger than 4MiB must be appended in 4MiB chunks. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="content"> Library file chunk. </param>
        /// <param name="blobConditionAppendPosition"> Set this header to a byte offset at which the block is expected to be appended. The request succeeds only if the current offset matches this value. Otherwise, the request fails with the AppendPositionConditionNotMet error (HTTP status code 412 – Precondition Failed). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response Append(string libraryName, Stream content, long? blobConditionAppendPosition = null, CancellationToken cancellationToken = default)
        {
            using var scope = _clientDiagnostics.CreateScope("LibraryClient.Append");
            scope.Start();
            try
            {
                return RestClient.Append(libraryName, content, blobConditionAppendPosition, cancellationToken);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Lists Library. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual AsyncPageable<LibraryResource> ListAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => RestClient.CreateListRequest();
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => RestClient.CreateListNextPageRequest(nextLink);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, LibraryResource.DeserializeLibraryResource, _clientDiagnostics, _pipeline, "LibraryClient.List", "value", "nextLink", cancellationToken);
        }

        /// <summary> Lists Library. </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Pageable<LibraryResource> List(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => RestClient.CreateListRequest();
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => RestClient.CreateListNextPageRequest(nextLink);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, LibraryResource.DeserializeLibraryResource, _clientDiagnostics, _pipeline, "LibraryClient.List", "value", "nextLink", cancellationToken);
        }

        /// <summary> Flush Library. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="libraryName"/> is null. </exception>
        public virtual async Task<LibraryFlushOperation> StartFlushAsync(string libraryName, CancellationToken cancellationToken = default)
        {
            if (libraryName == null)
            {
                throw new ArgumentNullException(nameof(libraryName));
            }

            using var scope = _clientDiagnostics.CreateScope("LibraryClient.StartFlush");
            scope.Start();
            try
            {
                var originalResponse = await RestClient.FlushAsync(libraryName, cancellationToken).ConfigureAwait(false);
                return new LibraryFlushOperation(_clientDiagnostics, _pipeline, RestClient.CreateFlushRequest(libraryName).Request, originalResponse);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Flush Library. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="libraryName"/> is null. </exception>
        public virtual LibraryFlushOperation StartFlush(string libraryName, CancellationToken cancellationToken = default)
        {
            if (libraryName == null)
            {
                throw new ArgumentNullException(nameof(libraryName));
            }

            using var scope = _clientDiagnostics.CreateScope("LibraryClient.StartFlush");
            scope.Start();
            try
            {
                var originalResponse = RestClient.Flush(libraryName, cancellationToken);
                return new LibraryFlushOperation(_clientDiagnostics, _pipeline, RestClient.CreateFlushRequest(libraryName).Request, originalResponse);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Delete Library. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="libraryName"/> is null. </exception>
        public virtual async Task<LibraryDeleteOperation> StartDeleteAsync(string libraryName, CancellationToken cancellationToken = default)
        {
            if (libraryName == null)
            {
                throw new ArgumentNullException(nameof(libraryName));
            }

            using var scope = _clientDiagnostics.CreateScope("LibraryClient.StartDelete");
            scope.Start();
            try
            {
                var originalResponse = await RestClient.DeleteAsync(libraryName, cancellationToken).ConfigureAwait(false);
                return new LibraryDeleteOperation(_clientDiagnostics, _pipeline, RestClient.CreateDeleteRequest(libraryName).Request, originalResponse);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Delete Library. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="libraryName"/> is null. </exception>
        public virtual LibraryDeleteOperation StartDelete(string libraryName, CancellationToken cancellationToken = default)
        {
            if (libraryName == null)
            {
                throw new ArgumentNullException(nameof(libraryName));
            }

            using var scope = _clientDiagnostics.CreateScope("LibraryClient.StartDelete");
            scope.Start();
            try
            {
                var originalResponse = RestClient.Delete(libraryName, cancellationToken);
                return new LibraryDeleteOperation(_clientDiagnostics, _pipeline, RestClient.CreateDeleteRequest(libraryName).Request, originalResponse);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Creates a library with the library name. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="libraryName"/> is null. </exception>
        public virtual async Task<LibraryCreateOperation> StartCreateAsync(string libraryName, CancellationToken cancellationToken = default)
        {
            if (libraryName == null)
            {
                throw new ArgumentNullException(nameof(libraryName));
            }

            using var scope = _clientDiagnostics.CreateScope("LibraryClient.StartCreate");
            scope.Start();
            try
            {
                var originalResponse = await RestClient.CreateAsync(libraryName, cancellationToken).ConfigureAwait(false);
                return new LibraryCreateOperation(_clientDiagnostics, _pipeline, RestClient.CreateCreateRequest(libraryName).Request, originalResponse);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Creates a library with the library name. </summary>
        /// <param name="libraryName"> file name to upload. Minimum length of the filename should be 1 excluding the extension length. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="libraryName"/> is null. </exception>
        public virtual LibraryCreateOperation StartCreate(string libraryName, CancellationToken cancellationToken = default)
        {
            if (libraryName == null)
            {
                throw new ArgumentNullException(nameof(libraryName));
            }

            using var scope = _clientDiagnostics.CreateScope("LibraryClient.StartCreate");
            scope.Start();
            try
            {
                var originalResponse = RestClient.Create(libraryName, cancellationToken);
                return new LibraryCreateOperation(_clientDiagnostics, _pipeline, RestClient.CreateCreateRequest(libraryName).Request, originalResponse);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
