// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Analytics.Synapse.Artifacts.Models;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Synapse.Artifacts
{
    internal partial class KqlScriptRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of KqlScriptRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The workspace development endpoint, for example `https://myworkspace.dev.azuresynapse.net`. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="endpoint"/> is null. </exception>
        public KqlScriptRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint)
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string kqlScriptName, KqlScriptResource kqlScript)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/kqlScripts/", false);
            uri.AppendPath(kqlScriptName, true);
            uri.AppendQuery("api-version", "2021-11-01-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(kqlScript);
            request.Content = content;
            return message;
        }

        /// <summary> Creates or updates a KQL Script. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="kqlScript"> KQL script. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> or <paramref name="kqlScript"/> is null. </exception>
        public async Task<Response> CreateOrUpdateAsync(string kqlScriptName, KqlScriptResource kqlScript, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }
            if (kqlScript == null)
            {
                throw new ArgumentNullException(nameof(kqlScript));
            }

            using var message = CreateCreateOrUpdateRequest(kqlScriptName, kqlScript);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates or updates a KQL Script. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="kqlScript"> KQL script. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> or <paramref name="kqlScript"/> is null. </exception>
        public Response CreateOrUpdate(string kqlScriptName, KqlScriptResource kqlScript, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }
            if (kqlScript == null)
            {
                throw new ArgumentNullException(nameof(kqlScript));
            }

            using var message = CreateCreateOrUpdateRequest(kqlScriptName, kqlScript);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetByNameRequest(string kqlScriptName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/kqlScripts/", false);
            uri.AppendPath(kqlScriptName, true);
            uri.AppendQuery("api-version", "2021-11-01-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Get KQL script by name. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> is null. </exception>
        public async Task<Response<KqlScriptResource>> GetByNameAsync(string kqlScriptName, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }

            using var message = CreateGetByNameRequest(kqlScriptName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        KqlScriptResource value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = KqlScriptResource.DeserializeKqlScriptResource(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get KQL script by name. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> is null. </exception>
        public Response<KqlScriptResource> GetByName(string kqlScriptName, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }

            using var message = CreateGetByNameRequest(kqlScriptName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        KqlScriptResource value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = KqlScriptResource.DeserializeKqlScriptResource(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateDeleteByNameRequest(string kqlScriptName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/kqlScripts/", false);
            uri.AppendPath(kqlScriptName, true);
            uri.AppendQuery("api-version", "2021-11-01-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Delete KQL script by name. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> is null. </exception>
        public async Task<Response> DeleteByNameAsync(string kqlScriptName, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }

            using var message = CreateDeleteByNameRequest(kqlScriptName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete KQL script by name. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> is null. </exception>
        public Response DeleteByName(string kqlScriptName, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }

            using var message = CreateDeleteByNameRequest(kqlScriptName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRenameRequest(string kqlScriptName, ArtifactRenameRequest renameRequest)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/kqlScripts/", false);
            uri.AppendPath(kqlScriptName, true);
            uri.AppendPath("/rename", false);
            uri.AppendQuery("api-version", "2021-11-01-preview", true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(renameRequest);
            request.Content = content;
            return message;
        }

        /// <summary> Rename KQL script. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="renameRequest"> Rename request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> or <paramref name="renameRequest"/> is null. </exception>
        public async Task<Response> RenameAsync(string kqlScriptName, ArtifactRenameRequest renameRequest, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }
            if (renameRequest == null)
            {
                throw new ArgumentNullException(nameof(renameRequest));
            }

            using var message = CreateRenameRequest(kqlScriptName, renameRequest);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Rename KQL script. </summary>
        /// <param name="kqlScriptName"> KQL script name. </param>
        /// <param name="renameRequest"> Rename request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="kqlScriptName"/> or <paramref name="renameRequest"/> is null. </exception>
        public Response Rename(string kqlScriptName, ArtifactRenameRequest renameRequest, CancellationToken cancellationToken = default)
        {
            if (kqlScriptName == null)
            {
                throw new ArgumentNullException(nameof(kqlScriptName));
            }
            if (renameRequest == null)
            {
                throw new ArgumentNullException(nameof(renameRequest));
            }

            using var message = CreateRenameRequest(kqlScriptName, renameRequest);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
